/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.RelativePath;
import hudson.Util;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Messages;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.OsAuthDescriptor;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.plugins.openstack.compute.UserDataConfig;
import jenkins.plugins.openstack.compute.auth.OpenstackCredential;
import jenkins.plugins.openstack.compute.auth.OpenstackCredentials;
import jenkins.plugins.openstack.compute.internal.Openstack;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.api.exceptions.ConnectionException;
import org.openstack4j.model.compute.Flavor;
import org.openstack4j.model.compute.ext.AvailabilityZone;

@Extension
@Restricted(value={NoExternalUse.class})
public final class SlaveOptionsDescriptor
extends OsAuthDescriptor<SlaveOptions> {
    private static final Logger LOGGER = Logger.getLogger(SlaveOptionsDescriptor.class.getName());
    public static final FormValidation OK = FormValidation.ok();
    public static final FormValidation REQUIRED = FormValidation.error((String)Messages.FormValidation_ValidateRequired());

    public SlaveOptionsDescriptor() {
        super(SlaveOptions.class);
    }

    public String getDisplayName() {
        return "Slave Options";
    }

    private SlaveOptions opts() {
        return JCloudsCloud.DescriptorImpl.getDefaultOptions();
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckInstanceCap(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="instanceCap") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getInstanceCap());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return REQUIRED;
        }
        return FormValidation.validatePositiveInteger((String)value);
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckInstancesMin(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="instancesMin") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getInstancesMin());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return REQUIRED;
        }
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckStartTimeout(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="startTimeout") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getStartTimeout());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return REQUIRED;
        }
        return FormValidation.validatePositiveInteger((String)value);
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckNumExecutors(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="numExecutors") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getNumExecutors());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return REQUIRED;
        }
        return FormValidation.validatePositiveInteger((String)value);
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckRetentionTime(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="retentionTime") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getRetentionTime());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return REQUIRED;
        }
        try {
            if (Integer.parseInt(value) == -1) {
                return FormValidation.ok((String)"Keep forever");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    @OsAuthDescriptor.InjectOsAuth
    @Restricted(value={DoNotUse.class})
    public ListBoxModel doFillFloatingIpPoolItems(@QueryParameter String floatingIpPool, @QueryParameter String endPointUrl, @QueryParameter boolean ignoreSsl, @QueryParameter String credentialId, @QueryParameter String zone) {
        ListBoxModel m = new ListBoxModel();
        m.add("None specified", "");
        String valueOrEmpty = Util.fixNull((String)floatingIpPool);
        try {
            OpenstackCredential openstackCredential = OpenstackCredentials.getCredential(credentialId);
            if (SlaveOptionsDescriptor.haveAuthDetails(endPointUrl, openstackCredential, zone)) {
                Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone);
                for (String p : openstack.getSortedIpPools()) {
                    m.add(p);
                }
            }
        }
        catch (FormValidation | AuthenticationException | ConnectionException ex) {
            LOGGER.log(Level.FINEST, "Openstack call failed", ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (!SlaveOptionsDescriptor.hasValue(m, valueOrEmpty)) {
            m.add(valueOrEmpty);
        }
        return m;
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckFloatingIpPool(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="floatingIpPool") String def) {
        String d;
        if (Util.fixEmpty((String)value) == null && (d = SlaveOptionsDescriptor.getDefault(def, this.opts().getFloatingIpPool())) != null) {
            return FormValidation.ok((String)this.def(d));
        }
        return OK;
    }

    @OsAuthDescriptor.InjectOsAuth
    @Restricted(value={DoNotUse.class})
    public ListBoxModel doFillHardwareIdItems(@QueryParameter String hardwareId, @QueryParameter String endPointUrl, @QueryParameter boolean ignoreSsl, @QueryParameter String credentialId, @QueryParameter String zone) {
        ListBoxModel m = new ListBoxModel();
        m.add("None specified", "");
        String valueOrEmpty = Util.fixNull((String)hardwareId);
        try {
            OpenstackCredential openstackCredential = OpenstackCredentials.getCredential(credentialId);
            if (SlaveOptionsDescriptor.haveAuthDetails(endPointUrl, openstackCredential, zone)) {
                Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone);
                for (Flavor flavor : openstack.getSortedFlavors()) {
                    String value = flavor.getId();
                    String displayText = String.format("%s (%s)", flavor.getName(), value);
                    m.add(displayText, value);
                }
            }
        }
        catch (FormValidation | AuthenticationException | ConnectionException ex) {
            LOGGER.log(Level.FINEST, "Openstack call failed", ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (!SlaveOptionsDescriptor.hasValue(m, valueOrEmpty)) {
            m.add(hardwareId);
        }
        return m;
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckHardwareId(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="hardwareId") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getHardwareId());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return REQUIRED;
        }
        return OK;
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckNetworkId(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="networkId") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getNetworkId());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return OK;
        }
        return OK;
    }

    @Restricted(value={DoNotUse.class})
    public ListBoxModel doFillUserDataIdItems() {
        ListBoxModel m = new ListBoxModel();
        m.add("None specified", "");
        ConfigProvider provider = this.getConfigProvider();
        for (Config config : provider.getAllConfigs()) {
            m.add(config.name, config.id);
        }
        return m;
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckUserDataId(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="userDataId") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getUserDataId());
            if (d != null) {
                String name = this.getConfigProvider().getConfigById((String)d).name;
                return this.getUserDataLink(d, this.def(name));
            }
            return OK;
        }
        return this.getUserDataLink(value, "View file");
    }

    private FormValidation getUserDataLink(String id, String name) {
        return FormValidation.okWithMarkup((String)("<a target='_blank' href='" + Jenkins.getActiveInstance().getRootUrl() + "configfiles/editConfig?id=" + Util.escape((String)id) + "'>" + Util.escape((String)name) + "</a>"));
    }

    private ConfigProvider getConfigProvider() {
        ExtensionList providers = ConfigProvider.all();
        return (ConfigProvider)providers.get(UserDataConfig.UserDataConfigProvider.class);
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckSecurityGroups(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="securityGroups") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getSecurityGroups());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return OK;
        }
        return OK;
    }

    @OsAuthDescriptor.InjectOsAuth
    @Restricted(value={DoNotUse.class})
    public ComboBoxModel doFillAvailabilityZoneItems(@QueryParameter String availabilityZone, @QueryParameter String endPointUrl, @QueryParameter boolean ignoreSsl, @QueryParameter String credentialId, @QueryParameter String zone) {
        ComboBoxModel m = new ComboBoxModel();
        try {
            OpenstackCredential openstackCredential = OpenstackCredentials.getCredential(credentialId);
            if (SlaveOptionsDescriptor.haveAuthDetails(endPointUrl, openstackCredential, zone)) {
                Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone);
                for (AvailabilityZone availabilityZone2 : openstack.getAvailabilityZones()) {
                    String value = availabilityZone2.getZoneName();
                    m.add((Object)value);
                }
            }
        }
        catch (FormValidation | AuthenticationException | ConnectionException ex) {
            LOGGER.log(Level.FINEST, "Openstack call failed", ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return m;
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckAvailabilityZone(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="availabilityZone") String def, @RelativePath(value="..") @QueryParameter(value="endPointUrl") String endPointUrlCloud, @RelativePath(value="..") @QueryParameter(value="ignoreSsl") boolean ignoreSsl, @RelativePath(value="../..") @QueryParameter(value="endPointUrl") String endPointUrlTemplate, @RelativePath(value="..") @QueryParameter(value="credentialId") String credentialIdCloud, @RelativePath(value="../..") @QueryParameter(value="credentialId") String credentialIdTemplate, @RelativePath(value="..") @QueryParameter(value="zone") String zoneCloud, @RelativePath(value="../..") @QueryParameter(value="zone") String zoneTemplate) {
        if (Util.fixEmpty((String)value) == null) {
            String zone;
            String credentiaId;
            OpenstackCredential openstackCredential;
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getAvailabilityZone());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            String endPointUrl = SlaveOptionsDescriptor.getDefault(endPointUrlCloud, endPointUrlTemplate);
            if (SlaveOptionsDescriptor.haveAuthDetails(endPointUrl, openstackCredential = OpenstackCredentials.getCredential(credentiaId = SlaveOptionsDescriptor.getDefault(credentialIdCloud, credentialIdTemplate)), zone = SlaveOptionsDescriptor.getDefault(zoneCloud, zoneTemplate))) {
                try {
                    Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone);
                    int numberOfAZs = openstack.getAvailabilityZones().size();
                    if (numberOfAZs > 1) {
                        return FormValidation.warning((String)"Ambiguity warning: Multiple zones found.");
                    }
                }
                catch (FormValidation | AuthenticationException | ConnectionException ex) {
                    LOGGER.log(Level.FINEST, "Openstack call failed", ex);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        return OK;
    }

    @OsAuthDescriptor.InjectOsAuth
    @Restricted(value={DoNotUse.class})
    public ListBoxModel doFillKeyPairNameItems(@QueryParameter String keyPairName, @QueryParameter String endPointUrl, @QueryParameter boolean ignoreSsl, @QueryParameter String credentialId, @QueryParameter String zone) {
        ListBoxModel m = new ListBoxModel();
        m.add("None specified", "");
        String valueOrEmpty = Util.fixNull((String)keyPairName);
        try {
            OpenstackCredential openstackCredential = OpenstackCredentials.getCredential(credentialId);
            if (SlaveOptionsDescriptor.haveAuthDetails(endPointUrl, openstackCredential, zone)) {
                Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone);
                for (String value : openstack.getSortedKeyPairNames()) {
                    m.add(value);
                }
            }
        }
        catch (FormValidation | AuthenticationException | ConnectionException ex) {
            LOGGER.log(Level.FINEST, "Openstack call failed", ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (!SlaveOptionsDescriptor.hasValue(m, valueOrEmpty)) {
            m.add(keyPairName);
        }
        return m;
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckKeyPairName(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="keyPairName") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getKeyPairName());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return OK;
        }
        return OK;
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckJvmOptions(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="jvmOptions") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getJvmOptions());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return OK;
        }
        return OK;
    }

    @Restricted(value={DoNotUse.class})
    public FormValidation doCheckFsRoot(@QueryParameter String value, @RelativePath(value="../../slaveOptions") @QueryParameter(value="fsRoot") String def) {
        if (Util.fixEmpty((String)value) == null) {
            String d = SlaveOptionsDescriptor.getDefault(def, this.opts().getFsRoot());
            if (d != null) {
                return FormValidation.ok((String)this.def(d));
            }
            return OK;
        }
        return OK;
    }

    @Override
    public List<String> getAuthFieldsOffsets() {
        return Arrays.asList("..", "../..");
    }

    @Nonnull
    private String def(@CheckForNull Object val) {
        return val == null ? "" : "Inherited value: " + val;
    }
}

