/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsLauncher;
import jenkins.plugins.openstack.compute.JCloudsRetentionStrategy;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.plugins.openstack.compute.internal.DestroyMachine;
import jenkins.plugins.openstack.compute.internal.Openstack;
import jenkins.plugins.openstack.compute.slaveopts.LauncherFactory;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.PhaseExecutionAttachment;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.model.compute.Server;

public class JCloudsSlave
extends AbstractCloudSlave
implements TrackedItem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JCloudsSlave.class.getName());
    @Nonnull
    private final String cloudName;
    @Nonnull
    private SlaveOptions options;
    @Nonnull
    private final ProvisioningActivity.Id provisioningId;
    @Nonnull
    private String nodeId;
    private final long created = System.currentTimeMillis();
    @Deprecated
    private transient int overrideRetentionTime;
    @Deprecated
    private transient String jvmOptions;
    @Deprecated
    private transient String credentialsId;
    @Deprecated
    private transient String slaveType;
    @Deprecated
    private transient Server metadata;

    public JCloudsSlave(@Nonnull ProvisioningActivity.Id id, @Nonnull Server metadata, @Nonnull String labelString, @Nonnull SlaveOptions slaveOptions) throws IOException, Descriptor.FormException {
        super(metadata.getName(), null, slaveOptions.getFsRoot(), slaveOptions.getNumExecutors().intValue(), Node.Mode.NORMAL, labelString, null, (RetentionStrategy)new JCloudsRetentionStrategy(), Collections.singletonList(new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[]{new EnvironmentVariablesNodeProperty.Entry("OPENSTACK_PUBLIC_IP", Openstack.getPublicAddress(metadata))})));
        this.cloudName = id.getCloudName();
        this.provisioningId = id;
        this.options = slaveOptions;
        this.nodeId = metadata.getId();
        this.setLauncher((ComputerLauncher)new JCloudsLauncher(this.getLauncherFactory().createLauncher(this)));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "The fields are non-null after readResolve"})
    protected Object readResolve() {
        super.readResolve();
        if (this.options == null) {
            SlaveOptions.Builder builder = JCloudsCloud.DescriptorImpl.getDefaultOptions().getBuilder().jvmOptions(Util.fixEmpty((String)this.jvmOptions));
            LauncherFactory lf = "SSH".equals(this.slaveType) ? new LauncherFactory.SSH(this.credentialsId) : LauncherFactory.JNLP.JNLP;
            builder.launcherFactory(lf);
            if (this.overrideRetentionTime > 0) {
                builder = builder.retentionTime(this.overrideRetentionTime);
            }
            this.options = builder.build();
            this.jvmOptions = null;
            this.credentialsId = null;
            this.slaveType = null;
        }
        if (!(this.metadata == null || this.nodeId != null && this.nodeId.equals(this.metadata.getId()))) {
            this.nodeId = this.metadata.getId();
            this.metadata = null;
        }
        this.nodeId = this.nodeId.replaceFirst(".*/", "");
        return this;
    }

    @CheckForNull
    public String getPublicAddress() throws NoSuchElementException {
        return Openstack.getPublicAddress(JCloudsSlave.getOpenstack(this.cloudName).getServerById(this.nodeId));
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public String getPublicAddressIpv4() throws NoSuchElementException {
        return Openstack.getPublicAddressIpv4(JCloudsSlave.getOpenstack(this.cloudName).getServerById(this.nodeId));
    }

    @Nonnull
    public SlaveOptions getSlaveOptions() {
        this.options.getClass();
        return this.options;
    }

    @Nonnull
    public LauncherFactory getLauncherFactory() {
        LauncherFactory lf = this.options.getLauncherFactory();
        return lf == null ? LauncherFactory.JNLP.JNLP : lf;
    }

    @Nonnull
    String getServerId() {
        return this.nodeId;
    }

    public AbstractCloudComputer<JCloudsSlave> createComputer() {
        LOGGER.info("Creating a new computer for " + this.getNodeName());
        return new JCloudsComputer(this);
    }

    @Nonnull
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    public long getCreatedTime() {
        return this.created;
    }

    protected void _terminate(TaskListener listener) {
        CloudStatistics cloudStatistics = CloudStatistics.get();
        ProvisioningActivity activity = cloudStatistics.getActivityFor((TrackedItem)this);
        if (activity != null) {
            activity.enterIfNotAlready(ProvisioningActivity.Phase.COMPLETED);
            OfflineCause offlineCause = this.getFatalOfflineCause();
            if (offlineCause != null) {
                PhaseExecutionAttachment attachment = new PhaseExecutionAttachment(ProvisioningActivity.Status.WARN, offlineCause.toString());
                cloudStatistics.attach(activity, ProvisioningActivity.Phase.COMPLETED, attachment);
            }
        }
        AsyncResourceDisposer.get().dispose(new Disposable[]{new RecordDisposal(new DestroyMachine(this.cloudName, this.nodeId), this.provisioningId)});
    }

    @CheckForNull
    private OfflineCause getFatalOfflineCause() {
        Computer computer = this.toComputer();
        if (computer == null) {
            return null;
        }
        return ((JCloudsComputer)computer).getFatalOfflineCause();
    }

    private static Openstack getOpenstack(String cloudName) {
        return JCloudsCloud.getByName(cloudName).getOpenstack();
    }

    private static final class RecordDisposal
    implements Disposable {
        private static final long serialVersionUID = -3623764445481732365L;
        @Nonnull
        private final Disposable inner;
        @Nonnull
        private final ProvisioningActivity.Id provisioningId;

        private RecordDisposal(@Nonnull Disposable inner, @Nonnull ProvisioningActivity.Id provisioningId) {
            this.inner = inner;
            this.provisioningId = provisioningId;
        }

        @Nonnull
        public Disposable.State dispose() throws Throwable {
            try {
                return this.inner.dispose();
            }
            catch (Throwable ex) {
                CloudStatistics statistics = CloudStatistics.get();
                ProvisioningActivity activity = statistics.getPotentiallyCompletedActivityFor(this.provisioningId);
                if (activity != null) {
                    PhaseExecutionAttachment.ExceptionAttachment attachment = new PhaseExecutionAttachment.ExceptionAttachment(ProvisioningActivity.Status.WARN, ex);
                    statistics.attach(activity, ProvisioningActivity.Phase.COMPLETED, (PhaseExecutionAttachment)attachment);
                }
                throw ex;
            }
        }

        @Nonnull
        public String getDisplayName() {
            return this.inner.getDisplayName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordDisposal that = (RecordDisposal)o;
            if (!this.inner.equals(that.inner)) {
                return false;
            }
            return this.provisioningId.equals((Object)that.provisioningId);
        }

        public int hashCode() {
            int result = this.inner.hashCode();
            result = 31 * result + this.provisioningId.hashCode();
            return result;
        }
    }

    @Extension
    public static final class JCloudsSlaveDescriptor
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "JClouds Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

