/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Descriptor;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.JCloudsSlave;

public class JCloudsLauncher
extends DelegatingComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(JCloudsLauncher.class.getName());

    public JCloudsLauncher(@Nonnull ComputerLauncher launcher) {
        super(launcher);
    }

    public void launch(@Nonnull SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        Slave n = computer.getNode();
        if (!(n instanceof JCloudsSlave)) {
            LOGGER.warning(((Object)((Object)this)).getClass().getSimpleName() + " used to launch incompatible computer type " + computer.getClass());
            return;
        }
        JCloudsSlave node = (JCloudsSlave)n;
        Integer configuredTimeout = node.getSlaveOptions().getStartTimeout();
        if (configuredTimeout == null) {
            throw new NullPointerException();
        }
        long timeout = node.getCreatedTime() + (long)configuredTimeout.intValue();
        do {
            this.launcher(computer).launch(computer, listener);
            if (computer.isOnline()) {
                return;
            }
            listener.getLogger().println("Launcher failed to bring the node online. Retrying ...");
            Thread.sleep(2000L);
        } while (System.currentTimeMillis() < timeout);
        listener.getLogger().println("Launcher failed to bring the node online within timeout.");
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        try {
            this.launcher(computer).afterDisconnect(computer, listener);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to create launcher", e);
        }
    }

    public void beforeDisconnect(SlaveComputer computer, TaskListener listener) {
        try {
            this.launcher(computer).beforeDisconnect(computer, listener);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to create launcher", e);
        }
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "Since 2.1, tha launcher is injected in constructor but we need this as a fallback for the slaves that survived the upgrade."})
    private ComputerLauncher launcher(SlaveComputer computer) throws IOException {
        if (this.launcher != null) {
            return this.launcher;
        }
        JCloudsSlave slave = (JCloudsSlave)computer.getNode();
        this.launcher = slave == null ? new JNLPLauncher() : slave.getLauncherFactory().createLauncher(slave);
        return this.launcher;
    }
}

