/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Executor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.slaves.OfflineCause;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.ServerScope;
import jenkins.plugins.openstack.compute.internal.DestroyMachine;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.api.exceptions.StatusCode;
import org.openstack4j.model.compute.Server;

@Extension
@Restricted(value={NoExternalUse.class})
public final class JCloudsCleanupThread
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(JCloudsCleanupThread.class.getName());
    @Nonnull
    private final ListMultimap<String, String> stillFips = ArrayListMultimap.create();

    public JCloudsCleanupThread() {
        super("OpenStack slave cleanup");
    }

    public long getRecurrencePeriod() {
        return 600000L;
    }

    public void execute(TaskListener listener) {
        this.terminateNodesPendingDeletion();
        HashMap<JCloudsCloud, List<Server>> runningServers = this.destroyServersOutOfScope();
        this.terminatesNodesWithoutServers(runningServers);
        this.cleanOrphanedFips();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOrphanedFips() {
        for (JCloudsCloud cloud : JCloudsCloud.getClouds()) {
            List<String> cloudStillFips = this.getStillFipsForCloud(cloud);
            ArrayList<String> leaked = new ArrayList<String>(cloud.getOpenstack().getFreeFipIds());
            ArrayList<String> freed = new ArrayList<String>(leaked);
            leaked.retainAll(cloudStillFips);
            freed.removeAll(leaked);
            ListMultimap<String, String> listMultimap = this.stillFips;
            synchronized (listMultimap) {
                cloudStillFips.clear();
                cloudStillFips.addAll(freed);
            }
            for (String fip : leaked) {
                try {
                    cloud.getOpenstack().destroyFip(fip);
                }
                catch (ClientResponseException ex) {
                    if (ex.getStatusCode() == StatusCode.FORBIDDEN) continue;
                    LOGGER.log(Level.WARNING, "Unable to release leaked floating IP", ex);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Unable to release leaked floating IP", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getStillFipsForCloud(JCloudsCloud cloud) {
        ListMultimap<String, String> listMultimap = this.stillFips;
        synchronized (listMultimap) {
            return this.stillFips.get((Object)cloud.name);
        }
    }

    private void terminateNodesPendingDeletion() {
        for (JCloudsComputer comp : JCloudsComputer.getAll()) {
            if (!comp.isIdle()) continue;
            OfflineCause offlineCause = comp.getFatalOfflineCause();
            if (!comp.isPendingDelete() && offlineCause == null) continue;
            LOGGER.log(Level.INFO, "Deleting pending node " + comp.getName() + ". Reason: " + comp.getOfflineCause());
            this.deleteComputer(comp);
        }
    }

    private void deleteComputer(JCloudsComputer comp) {
        try {
            comp.deleteSlave();
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to disconnect and delete " + comp.getName(), e);
        }
    }

    private void deleteComputer(JCloudsComputer comp, CauseOfInterruption coi) {
        try {
            for (Executor e : comp.getExecutors()) {
                e.interrupt(Result.ABORTED, new CauseOfInterruption[]{coi});
            }
            comp.deleteSlave();
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to disconnect and delete " + comp.getName(), e);
        }
    }

    @Nonnull
    private HashMap<JCloudsCloud, List<Server>> destroyServersOutOfScope() {
        HashMap<JCloudsCloud, List<Server>> runningServers = new HashMap<JCloudsCloud, List<Server>>();
        for (JCloudsCloud jc : JCloudsCloud.getClouds()) {
            runningServers.put(jc, new ArrayList());
            List<Server> servers = jc.getOpenstack().getRunningNodes();
            for (Server server : servers) {
                ServerScope scope = ServerScope.extract(server);
                if (scope.isOutOfScope(server)) {
                    LOGGER.info("Server " + server.getName() + " run out of its scope " + scope + ". Terminating: " + server);
                    AsyncResourceDisposer.get().dispose(new Disposable[]{new DestroyMachine(jc.name, server.getId())});
                    continue;
                }
                runningServers.get(jc).add(server);
            }
        }
        return runningServers;
    }

    private void terminatesNodesWithoutServers(@Nonnull HashMap<JCloudsCloud, List<Server>> runningServers) {
        HashMap<String, JCloudsComputer> jenkinsComputers = new HashMap<String, JCloudsComputer>();
        for (JCloudsComputer jCloudsComputer : JCloudsComputer.getAll()) {
            jenkinsComputers.put(jCloudsComputer.getNode().getServerId(), jCloudsComputer);
        }
        for (Map.Entry entry : runningServers.entrySet()) {
            for (Server server : (List)entry.getValue()) {
                jenkinsComputers.remove(server.getId());
            }
        }
        for (Map.Entry entry : jenkinsComputers.entrySet()) {
            JCloudsCloud cloud;
            JCloudsComputer computer = (JCloudsComputer)((Object)entry.getValue());
            String id = (String)entry.getKey();
            String cloudName = computer.getId().getCloudName();
            try {
                cloud = JCloudsCloud.getByName(cloudName);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning("The cloud " + cloudName + " does not longer exists for " + computer.getName());
                continue;
            }
            try {
                Server explicitLookup = cloud.getOpenstack().getServerById(id);
                LOGGER.severe(((Object)((Object)this)).getClass().getSimpleName() + " incorrectly detected orphaned computer for " + explicitLookup);
            }
            catch (NoSuchElementException explicitLookup) {
                String msg = "OpenStack server (" + id + ") is not running for computer " + computer.getName() + ". Terminating!";
                LOGGER.warning(msg);
                this.deleteComputer(computer, new MessageInterruption(msg));
            }
        }
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }

    protected Level getSlowLoggingLevel() {
        return Level.INFO;
    }

    private static class MessageInterruption
    extends CauseOfInterruption {
        private static final long serialVersionUID = 7125610351278586647L;
        private final String msg;

        private MessageInterruption(String msg) {
            this.msg = msg;
        }

        public String getShortDescription() {
            return this.msg;
        }
    }
}

