/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import com.cloudbees.openid4java.team.TeamExtensionFactory;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.openid.Identity;
import hudson.plugins.openid.Messages;
import hudson.plugins.openid.OpenIdSession;
import hudson.plugins.openid.OpenIdUserProperty;
import hudson.plugins.openid.YadisResolver2;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.server.RealmVerifierFactory;
import org.openid4java.util.HttpClientFactory;
import org.openid4java.util.HttpFetcherFactory;
import org.openid4java.util.ProxyProperties;

public class OpenIdSsoSecurityRealm
extends SecurityRealm {
    private volatile transient ConsumerManager manager;
    public final String endpoint;
    private volatile transient DiscoveryInformation discoveredEndpoint;

    @DataBoundConstructor
    public OpenIdSsoSecurityRealm(String endpoint) throws IOException, OpenIDException {
        this.endpoint = endpoint;
        this.getDiscoveredEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerManager getManager() throws ConsumerException {
        if (this.manager != null) {
            return this.manager;
        }
        OpenIdSsoSecurityRealm openIdSsoSecurityRealm = this;
        synchronized (openIdSsoSecurityRealm) {
            if (this.manager == null) {
                this.manager = this.createManager();
                this.manager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
                this.manager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
            }
        }
        return this.manager;
    }

    protected ConsumerManager createManager() throws ConsumerException {
        Hudson instance = Hudson.getInstance();
        if (instance.proxy != null) {
            ProxyProperties props = new ProxyProperties();
            props.setProxyHostName(instance.proxy.name);
            props.setProxyPort(instance.proxy.port);
            props.setUserName(instance.proxy.getUserName());
            props.setProxyHostName(instance.proxy.getPassword());
            HttpClientFactory.setProxyProperties((ProxyProperties)props);
        }
        HttpFetcherFactory fetcherFactory = new HttpFetcherFactory();
        YadisResolver2 resolver = new YadisResolver2(fetcherFactory);
        ConsumerManager manager = new ConsumerManager(new RealmVerifierFactory((YadisResolver)resolver), new Discovery(), fetcherFactory);
        manager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        manager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
        manager.getDiscovery().setYadisResolver((YadisResolver)resolver);
        return manager;
    }

    private DiscoveryInformation getDiscoveredEndpoint() throws IOException, OpenIDException {
        if (this.discoveredEndpoint == null) {
            Discovery d = new Discovery();
            d.setYadisResolver((YadisResolver)new YadisResolver2(new HttpFetcherFactory()));
            List r = d.discover(this.endpoint);
            this.discoveredEndpoint = r == null || r.isEmpty() ? new DiscoveryInformation(new URL(this.endpoint)) : (DiscoveryInformation)r.get(0);
        }
        return this.discoveredEndpoint;
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return authentication;
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        });
    }

    public HttpResponse doCommenceLogin(@QueryParameter String from) throws IOException, OpenIDException {
        if (from == null || !from.startsWith("/")) {
            from = Stapler.getCurrentRequest().getHeader("Referer") != null ? Stapler.getCurrentRequest().getHeader("Referer") : Jenkins.getInstance().getRootUrl();
        }
        final String referer = from;
        return new OpenIdSession(this.getManager(), this.endpoint, "securityRealm/finishLogin"){

            protected HttpResponse onSuccess(Identity id) throws IOException {
                UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)id.getEffectiveNick(), (Object)"", id.getGrantedAuthorities().toArray(new GrantedAuthority[id.getGrantedAuthorities().size()]));
                SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                User u = User.get((String)token.getName());
                id.updateProfile(u);
                OpenIdUserProperty p = (OpenIdUserProperty)u.getProperty(OpenIdUserProperty.class);
                if (p != null) {
                    p.addIdentifier(id.getOpenId());
                }
                return new HttpRedirect(referer);
            }
        }.doCommenceLogin();
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException, OpenIDException {
        OpenIdSession session = OpenIdSession.getCurrent();
        if (session == null) {
            throw new Failure(Messages.OpenIdLoginService_SessionNotFound());
        }
        return session.doFinishLogin(request);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "OpenID SSO";
        }

        public FormValidation doValidate(@QueryParameter String endpoint) {
            try {
                new Discovery().discover(endpoint);
                return FormValidation.ok((String)"OK");
            }
            catch (DiscoveryException e) {
                return FormValidation.error((Throwable)e, (String)("Invalid provider URL: " + endpoint));
            }
        }

        static {
            TeamExtensionFactory.install();
        }
    }
}

