/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.openid.OpenIdExtension;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.acegisecurity.GrantedAuthority;
import org.openid4java.OpenIDException;
import org.openid4java.message.AuthSuccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identity {
    private final String openId;
    private String nick;
    private String fullName;
    private String email;
    private final List<GrantedAuthority> teams;
    private final ListMultimap<String, String> properties;

    public Identity(AuthSuccess authSuccess) throws OpenIDException {
        this.openId = authSuccess.getIdentity();
        this.teams = Lists.newArrayList();
        this.properties = Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<String>>(){

            public List<String> get() {
                return new ArrayList<String>();
            }
        });
        OpenIdExtension.processResponse(authSuccess, this);
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public String getEffectiveNick() {
        if (this.getNick() != null) {
            return this.getNick();
        }
        if (this.getEmail() != null) {
            return this.getEmail();
        }
        return this.getOpenId();
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public List<GrantedAuthority> getGrantedAuthorities() {
        return this.teams;
    }

    public ListMultimap<String, String> getProperties() {
        return this.properties;
    }

    public void updateProfile(User u) throws IOException {
        if (this.getFullName() != null) {
            u.setFullName(this.getFullName());
        }
        if (this.getEmail() != null) {
            u.addProperty((UserProperty)new Mailer.UserProperty(this.getEmail()));
        }
    }
}

