/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openstf.util;

import com.sun.jersey.api.client.ClientHandlerException;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.Computer;
import hudson.plugins.openstf.Messages;
import hudson.plugins.openstf.exception.ApiFailedException;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.Configuration;
import io.swagger.client.api.DevicesApi;
import io.swagger.client.api.UserApi;
import io.swagger.client.model.AddUserDevicePayload;
import io.swagger.client.model.DeviceListResponseDevices;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Utils {
    public static Map<String, String> convertDeviceToMap(DeviceListResponseDevices device) {
        HashMap<String, String> convertedDevice = new HashMap<String, String>();
        convertedDevice.put("image", device.image);
        convertedDevice.put("name", device.name);
        convertedDevice.put("version", device.version);
        convertedDevice.put("sdk", device.sdk);
        return convertedDevice;
    }

    public static Map<String, String> expandVariables(EnvVars envVars, Map<String, String> buildVars, Map<String, String> filter) {
        HashMap<String, String> expandedFilter = new HashMap<String, String>();
        HashMap<String, String> vars = new HashMap<String, String>((Map<String, String>)envVars);
        if (buildVars != null) {
            vars.putAll(buildVars);
        }
        for (Map.Entry<String, String> entry : filter.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String result = Util.fixEmptyAndTrim((String)value);
            if (result != null) {
                result = Util.replaceMacro((String)result, vars);
            }
            expandedFilter.put(key, result);
        }
        return expandedFilter;
    }

    public static Charset getDefaultCharset() {
        try {
            return Computer.currentComputer().getDefaultCharset();
        }
        catch (NullPointerException ex) {
            return Charset.defaultCharset();
        }
    }

    public static ListBoxModel getSTFDeviceAttributeListBoxItems() {
        ListBoxModel items = new ListBoxModel();
        for (String value : Utils.getSTFDeviceAttributeSet()) {
            items.add(value);
        }
        return items;
    }

    public static ComboBoxModel getSTFDeviceAttributeValueComboBoxItems(String attribute) {
        ComboBoxModel items = new ComboBoxModel();
        items.add((Object)"any");
        for (String value : Utils.getSTFDeviceAttributeValueSet(attribute)) {
            items.add((Object)value);
        }
        return items;
    }

    public static ListBoxModel getSTFDeviceAttributeValueListBoxItems(String attribute) {
        ListBoxModel items = new ListBoxModel();
        for (String value : Utils.getSTFDeviceAttributeValueSet(attribute)) {
            items.add(value);
        }
        return items;
    }

    public static void setupSTFApiClient(String stfApiEndpoint, boolean ignoreCertError, String stfToken) {
        ApiClient stfApiClient = new ApiClient();
        if (ignoreCertError) {
            stfApiClient.setIgnoreCertError(true);
        }
        stfApiClient.setBasePath(stfApiEndpoint);
        stfApiClient.setApiKeyPrefix("Bearer");
        stfApiClient.setApiKey(stfToken);
        Configuration.setDefaultApiClient((ApiClient)stfApiClient);
    }

    public static List<DeviceListResponseDevices> getDeviceList() throws ApiFailedException {
        return Utils.getDeviceList(null);
    }

    public static List<DeviceListResponseDevices> getDeviceList(Map<String, String> filter) throws ApiFailedException {
        List deviceList;
        String fields = "serial,name,model,version,sdk,image,present,owner,provider,notes,manufacturer,abi,battery";
        DevicesApi stfDevicesApi = new DevicesApi();
        try {
            deviceList = stfDevicesApi.getDevices(fields).getDevices();
        }
        catch (ApiException ex) {
            throw new ApiFailedException("GET /devices API failed");
        }
        if (filter != null) {
            for (Map.Entry<String, String> entry : filter.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value.equals("any")) continue;
                ListIterator di = deviceList.listIterator();
                while (di.hasNext()) {
                    DeviceListResponseDevices device = (DeviceListResponseDevices)di.next();
                    Class<?> klass = device.getClass();
                    try {
                        Field field = klass.getField(key);
                        if (field.get(device) != null) {
                            String deviceValue = key.equals("battery") ? String.valueOf(device.battery.level) : (key.equals("provider") ? device.provider.name : field.get(device).toString());
                            if (value.matches("^/.+/$")) {
                                String regex = value.substring(1, value.length() - 1);
                                if (deviceValue.matches(regex)) continue;
                                di.remove();
                                continue;
                            }
                            if (value.equals(deviceValue)) continue;
                            di.remove();
                            continue;
                        }
                        if (value.equals("null")) continue;
                        di.remove();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
        }
        return deviceList;
    }

    public static DeviceListResponseDevices getSTFDeviceById(String deviceId) throws ApiFailedException {
        DeviceListResponseDevices device = null;
        DevicesApi stfDevicesApi = new DevicesApi();
        String fields = "serial,name,model,version,sdk,image,present,owner,remoteConnectUrl,provider,notes,manufacturer,abi,battery";
        try {
            device = stfDevicesApi.getDeviceBySerial(deviceId, fields).getDevice();
        }
        catch (ApiException ex) {
            throw new ApiFailedException("GET /devices/" + deviceId + " API failed");
        }
        return device;
    }

    public static void reserveSTFDevice(DeviceListResponseDevices device) throws ApiFailedException {
        UserApi stfUserApi = new UserApi();
        AddUserDevicePayload body = new AddUserDevicePayload();
        body.setSerial(device.serial);
        try {
            stfUserApi.addUserDevice(body);
        }
        catch (ApiException ex) {
            throw new ApiFailedException("POST /api/v1/user/devices API failed");
        }
    }

    public static void remoteConnectSTFDevice(DeviceListResponseDevices device) throws ApiFailedException {
        UserApi stfUserApi = new UserApi();
        try {
            stfUserApi.remoteConnectUserDeviceBySerial(device.serial);
        }
        catch (ApiException ex) {
            throw new ApiFailedException("POST /user/devices/" + device.serial + "/remoteConnect API failed");
        }
    }

    public static void remoteDisconnectSTFDevice(DeviceListResponseDevices device) throws ApiFailedException {
        UserApi stfUserApi = new UserApi();
        try {
            stfUserApi.remoteDisconnectUserDeviceBySerial(device.serial);
        }
        catch (ApiException ex) {
            throw new ApiFailedException("DELETE /api/v1/user/devices/" + device.serial + "/remoteConnect API failed");
        }
    }

    public static void releaseSTFDevice(DeviceListResponseDevices device) throws ApiFailedException {
        UserApi stfUserApi = new UserApi();
        try {
            stfUserApi.deleteUserDeviceBySerial(device.serial);
        }
        catch (ApiException ex) {
            throw new ApiFailedException("DELETE /api/v1/user/devices/" + device.serial + " API failed");
        }
    }

    public static boolean validateRegexValue(String value) {
        try {
            String regex = value.substring(1, value.length() - 1);
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    public static boolean validateDeviceFilter(Map<String, String> filter) {
        for (Map.Entry<String, String> entry : filter.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!value.matches("^/.+/$") || Utils.validateRegexValue(value)) continue;
            return false;
        }
        return true;
    }

    public static FormValidation validateSTFApiEndpoint(String stfApiEndpoint, boolean ignoreCertError) {
        if (stfApiEndpoint == null || stfApiEndpoint.equals("")) {
            return FormValidation.ok();
        }
        if (!stfApiEndpoint.startsWith("http://") && !stfApiEndpoint.startsWith("https://")) {
            return FormValidation.error((String)Messages.MALFORMED_STF_API_ENDPOINT_URL());
        }
        ApiClient stfApiClient = new ApiClient();
        if (ignoreCertError) {
            stfApiClient.setIgnoreCertError(true);
        }
        stfApiClient.setBasePath(stfApiEndpoint);
        stfApiClient.setConnectTimeout(10000);
        UserApi stfUserApi = new UserApi(stfApiClient);
        try {
            stfUserApi.getUser();
        }
        catch (ApiException ex) {
            String expectedMessage = "{\"success\":false,\"description\":\"Requires Authentication\"}";
            if (ex.getCode() != 401 || !ex.getResponseBody().equals(expectedMessage)) {
                return FormValidation.error((String)Messages.INVALID_STF_API_ENDPOINT_URL());
            }
        }
        catch (ClientHandlerException ex) {
            String message = ex.getMessage();
            if (message.startsWith("java.net.UnknownHostException:")) {
                return FormValidation.error((String)Messages.CANNOT_RESOLVE_HOST());
            }
            if (message.startsWith("java.net.SocketTimeoutException:")) {
                return FormValidation.error((String)Messages.CONNECTION_TIMEOUT());
            }
            if (message.startsWith("java.net.ConnectException:")) {
                return FormValidation.error((String)message.replaceAll("java.net.ConnectException: ", ""));
            }
            return FormValidation.error((String)message);
        }
        return FormValidation.ok();
    }

    public static FormValidation validateSTFToken(String stfApiEndpoint, boolean ignoreCertError, String stfToken) {
        if (stfApiEndpoint == null || stfApiEndpoint.equals("")) {
            if (stfToken != null && !stfToken.equals("")) {
                return FormValidation.error((String)Messages.STF_API_ENDPOINT_NOT_SET());
            }
        } else if (Utils.validateSTFApiEndpoint((String)stfApiEndpoint, (boolean)ignoreCertError).kind == FormValidation.Kind.OK) {
            if (stfToken == null || stfToken.equals("")) {
                return FormValidation.error((String)Messages.STF_TOKEN_REQUIRED());
            }
            if (!Utils.verifyToken(stfApiEndpoint, ignoreCertError, stfToken)) {
                return FormValidation.error((String)Messages.STF_TOKEN_NOT_VALID());
            }
        } else {
            return FormValidation.error((String)Messages.STF_API_ENDPOINT_NOT_VALID());
        }
        return FormValidation.ok();
    }

    private static TreeSet<String> getSTFDeviceAttributeSet() {
        Field[] fields;
        TreeSet<String> items = new TreeSet<String>();
        String[] excludeAttributes = new String[]{"image", "owner", "present", "remoteConnectUrl"};
        for (Field f : fields = DeviceListResponseDevices.class.getFields()) {
            if (Arrays.asList(excludeAttributes).contains(f.getName())) continue;
            items.add(f.getName());
        }
        return items;
    }

    private static TreeSet<String> getSTFDeviceAttributeValueSet(String attribute) {
        TreeSet<String> items = new TreeSet<String>();
        try {
            for (DeviceListResponseDevices device : Utils.getDeviceList()) {
                Class<?> klass = device.getClass();
                try {
                    Field field = klass.getField(attribute);
                    if (field.get(device) == null) continue;
                    if (attribute.equals("battery")) {
                        items.add(String.valueOf(device.battery.level));
                        continue;
                    }
                    if (attribute.equals("provider")) {
                        items.add(device.provider.name);
                        continue;
                    }
                    items.add(field.get(device).toString());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        catch (ApiFailedException apiFailedException) {
            // empty catch block
        }
        return items;
    }

    private static boolean verifyToken(String stfApiEndpoint, boolean ignoreCertError, String stfToken) {
        Utils.setupSTFApiClient(stfApiEndpoint, ignoreCertError, stfToken);
        UserApi stfUserApi = new UserApi();
        try {
            stfUserApi.getUser();
            return true;
        }
        catch (ApiException ex) {
            return false;
        }
    }
}

