/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openstf;

import hudson.model.Action;
import hudson.plugins.openstf.Messages;
import java.net.URL;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;

public class STFReservedDeviceAction
implements Action {
    private final String stfApiEndpoint;
    private final Map<String, String> reservedDevice;

    public STFReservedDeviceAction(String stfApiEndpoint, Map<String, String> reservedDevice) {
        this.stfApiEndpoint = stfApiEndpoint;
        this.reservedDevice = reservedDevice;
    }

    @Exported
    public String getDeviceIcon() {
        String path = "/static/app/devices/icon/x120/";
        path = this.reservedDevice.get("image") != null ? path + this.reservedDevice.get("image") : path + "_default.jpg";
        try {
            URL iconUrl = new URL(new URL(this.stfApiEndpoint), path);
            return iconUrl.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Exported
    public String getSummary() {
        return Messages.PUBLISH_RESERVED_DEVICE_INFO(this.reservedDevice.get("name"), this.reservedDevice.get("sdk"), this.reservedDevice.get("version"));
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

