/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EphemeralNode;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.nomad.NomadCloud;
import org.jenkinsci.plugins.nomad.NomadComputer;
import org.jenkinsci.plugins.nomad.NomadRetentionStrategy;
import org.jenkinsci.plugins.nomad.NomadWorkerTemplate;
import org.kohsuke.stapler.DataBoundConstructor;

public class NomadWorker
extends AbstractCloudSlave
implements EphemeralNode {
    private static final Logger LOGGER = Logger.getLogger(NomadWorker.class.getName());
    private static final String NODE_DESCRIPTION = "Nomad Jenkins Worker";
    private final Boolean reusable;
    private final String cloudName;
    private final int idleTerminationInMinutes;

    public NomadWorker(String name, String cloudName, NomadWorkerTemplate template, String labelString, NomadRetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties) throws Descriptor.FormException, IOException {
        super(name, NODE_DESCRIPTION, template.getRemoteFs(), template.getNumExecutors(), template.getMode(), labelString, (ComputerLauncher)new JNLPLauncher(false), (RetentionStrategy)retentionStrategy, nodeProperties);
        this.cloudName = cloudName;
        this.reusable = template.getReusable();
        this.idleTerminationInMinutes = template.getIdleTerminationInMinutes();
    }

    @DataBoundConstructor
    public NomadWorker(String name, String cloudName, String remoteFS, String numExecutors, Node.Mode mode, String labelString, String idleTerminationInMinutes, boolean reusable) throws Descriptor.FormException, IOException {
        super(name, NODE_DESCRIPTION, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new JNLPLauncher(), (RetentionStrategy)new NomadRetentionStrategy(idleTerminationInMinutes), Collections.emptyList());
        this.cloudName = cloudName;
        this.reusable = reusable;
        this.idleTerminationInMinutes = Integer.parseInt(idleTerminationInMinutes);
    }

    public Node asNode() {
        return this;
    }

    public AbstractCloudComputer<NomadWorker> createComputer() {
        return new NomadComputer(this);
    }

    protected void _terminate(TaskListener listener) {
        LOGGER.log(Level.INFO, "Asking Nomad to deregister worker '" + this.getNodeName() + "'");
        this.getCloud().nomad().stopWorker(this.getNodeName(), this.getCloud().getNomadACL());
    }

    public NomadCloud getCloud() {
        return (NomadCloud)Jenkins.get().getCloud(this.cloudName);
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public Boolean getReusable() {
        return this.reusable;
    }

    public int getIdleTerminationInMinutes() {
        return this.idleTerminationInMinutes;
    }

    @Extension
    public static class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Nomad Worker";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

