/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.nomad.NomadCloud;
import org.kohsuke.stapler.DataBoundConstructor;

public class NomadSlaveTemplate
implements Describable<NomadSlaveTemplate> {
    private static final String SLAVE_PREFIX = "jenkins-";
    private static final Logger LOGGER = Logger.getLogger(NomadSlaveTemplate.class.getName());
    private final int idleTerminationInMinutes;
    private final int numExecutors;
    private final int cpu;
    private final int memory;
    private final int disk;
    private final int priority;
    private final String labels;
    private final String region;
    private final String remoteFs;
    private final String image;
    private final Boolean privileged;
    private final String network;
    private final String username;
    private final String password;
    private final String prefixCmd;
    private final Node.Mode mode;
    private NomadCloud cloud;
    private String driver;
    private String datacenters;
    private Set<LabelAtom> labelSet;

    @DataBoundConstructor
    public NomadSlaveTemplate(String cpu, String memory, String disk, String labels, String remoteFs, String idleTerminationInMinutes, String numExecutors, Node.Mode mode, String region, String priority, String image, String datacenters, String username, String password, Boolean privileged, String network, String prefixCmd) {
        this.cpu = Integer.parseInt(cpu);
        this.memory = Integer.parseInt(memory);
        this.disk = Integer.parseInt(disk);
        this.priority = Integer.parseInt(priority);
        this.idleTerminationInMinutes = Integer.parseInt(idleTerminationInMinutes);
        this.numExecutors = Integer.parseInt(numExecutors);
        this.mode = mode;
        this.remoteFs = remoteFs;
        this.labels = Util.fixNull((String)labels);
        this.labelSet = Label.parse((String)labels);
        this.region = region;
        this.image = image;
        this.datacenters = datacenters;
        this.username = username;
        this.password = password;
        this.privileged = privileged;
        this.network = network;
        this.prefixCmd = prefixCmd;
        this.readResolve();
    }

    protected Object readResolve() {
        this.driver = !this.image.equals("") ? "docker" : "java";
        return this;
    }

    public Descriptor<NomadSlaveTemplate> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public String createSlaveName() {
        return SLAVE_PREFIX + Long.toHexString(System.nanoTime());
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getMemory() {
        return this.memory;
    }

    public String getLabels() {
        return this.labels;
    }

    public int getIdleTerminationInMinutes() {
        return this.idleTerminationInMinutes;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDatacenters() {
        return this.datacenters;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDisk() {
        return this.disk;
    }

    public void setCloud(NomadCloud cloud) {
        this.cloud = cloud;
    }

    public NomadCloud getCloud() {
        return this.cloud;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    public String getImage() {
        return this.image;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrefixCmd() {
        return this.prefixCmd;
    }

    public String getDriver() {
        return this.driver;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public String getNetwork() {
        return this.network;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<NomadSlaveTemplate> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return null;
        }
    }
}

