/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EphemeralNode;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.nomad.NomadCloud;
import org.jenkinsci.plugins.nomad.NomadComputer;
import org.jenkinsci.plugins.nomad.NomadSlaveTemplate;

public class NomadSlave
extends AbstractCloudSlave
implements EphemeralNode {
    private static final Logger LOGGER = Logger.getLogger(NomadSlave.class.getName());
    private final NomadCloud cloud;

    public NomadSlave(NomadCloud cloud, String name, String nodeDescription, NomadSlaveTemplate template, String labelString, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, template.getRemoteFs(), template.getNumExecutors(), template.getMode(), labelString, (ComputerLauncher)new JNLPLauncher(), retentionStrategy, nodeProperties);
        this.cloud = cloud;
    }

    public Node asNode() {
        return this;
    }

    public AbstractCloudComputer createComputer() {
        return new NomadComputer(this);
    }

    protected void _terminate(TaskListener listener) {
        LOGGER.log(Level.INFO, "Asking Nomad to deregister slave '" + this.getNodeName() + "'");
        this.cloud.Nomad().stopSlave(this.getNodeName());
    }

    public NomadCloud getCloud() {
        return this.cloud;
    }

    @Extension
    public static class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Nomad Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

