/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import hudson.model.Executor;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.nomad.NomadCloud;
import org.jenkinsci.plugins.nomad.NomadSlave;

public class NomadComputer
extends AbstractCloudComputer<NomadSlave> {
    private static final Logger LOGGER = Logger.getLogger(NomadComputer.class.getName());
    private final NomadCloud cloud;

    public NomadComputer(NomadSlave slave) {
        super((AbstractCloudSlave)slave);
        this.cloud = slave.getCloud();
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        LOGGER.log(Level.INFO, " Computer " + (Object)((Object)this) + ": task accepted");
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        super.taskCompleted(executor, task, durationMS);
        LOGGER.log(Level.INFO, " Computer " + (Object)((Object)this) + ": task completed");
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        LOGGER.log(Level.WARNING, " Computer " + (Object)((Object)this) + " task completed with problems");
    }

    public String toString() {
        return String.format("%s (slave: %s)", this.getName(), this.getNode());
    }
}

