/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.nomad;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hudson.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.nomad.Api.Artifact;
import org.jenkinsci.plugins.nomad.Api.EphemeralDisk;
import org.jenkinsci.plugins.nomad.Api.Job;
import org.jenkinsci.plugins.nomad.Api.LogConfig;
import org.jenkinsci.plugins.nomad.Api.Resource;
import org.jenkinsci.plugins.nomad.Api.RestartPolicy;
import org.jenkinsci.plugins.nomad.Api.Task;
import org.jenkinsci.plugins.nomad.Api.TaskGroup;
import org.jenkinsci.plugins.nomad.NomadSlaveTemplate;

public final class NomadApi {
    private static final Logger LOGGER = Logger.getLogger(NomadApi.class.getName());
    private static final OkHttpClient client = new OkHttpClient();
    private final String nomadApi;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public NomadApi(String nomadApi) {
        this.nomadApi = nomadApi;
    }

    public void startSlave(String slaveName, String jnlpSecret, NomadSlaveTemplate template) {
        String slaveJob = this.buildSlaveJob(slaveName, jnlpSecret, template);
        LOGGER.log(Level.INFO, slaveJob);
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)slaveJob);
            Request request = new Request.Builder().url(this.nomadApi + "/v1/job/" + slaveName + "?region=" + template.getRegion()).put(body).build();
            client.newCall(request).execute().body().close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void stopSlave(String slaveName) {
        Request request = new Request.Builder().url(this.nomadApi + "/v1/job/" + slaveName).delete().build();
        try {
            client.newCall(request).execute().body().close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private Map<String, Object> buildDriverConfig(String name, String secret, NomadSlaveTemplate template) {
        HashMap<String, Object> driverConfig = new HashMap<String, Object>();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-jnlpUrl");
        args.add(Util.ensureEndsWith((String)template.getCloud().getJenkinsUrl(), (String)"/") + "computer/" + name + "/slave-agent.jnlp");
        if (template.getUsername() != null && !template.getUsername().isEmpty()) {
            HashMap<String, String> authConfig = new HashMap<String, String>();
            authConfig.put("username", template.getUsername());
            authConfig.put("password", template.getPassword());
            ArrayList<HashMap<String, String>> credentials = new ArrayList<HashMap<String, String>>();
            credentials.add(authConfig);
            driverConfig.put("auth", credentials);
        }
        if (!secret.isEmpty()) {
            args.add("-secret");
            args.add(secret);
        }
        if (template.getDriver().equals("java")) {
            driverConfig.put("jar_path", "/local/slave.jar");
            driverConfig.put("args", args);
        } else if (template.getDriver().equals("docker")) {
            String prefixCmd = template.getPrefixCmd();
            if (!prefixCmd.isEmpty()) {
                driverConfig.put("command", "/bin/bash");
                String argString = prefixCmd + "; java -jar /local/slave.jar ";
                argString = argString + StringUtils.join(args, (String)" ");
                args.clear();
                args.add("-c");
                args.add(argString);
            } else {
                driverConfig.put("command", "java");
                args.add(0, "-jar");
                args.add(1, "/local/slave.jar");
            }
            driverConfig.put("image", template.getImage());
            driverConfig.put("args", args);
            driverConfig.put("privileged", template.getPrivileged());
            driverConfig.put("network_mode", template.getNetwork());
        }
        return driverConfig;
    }

    String buildSlaveJob(String name, String secret, NomadSlaveTemplate template) {
        Task task = new Task("jenkins-slave", template.getDriver(), this.buildDriverConfig(name, secret, template), new Resource(template.getCpu(), template.getMemory()), new LogConfig(1, 10), new Artifact[]{new Artifact(template.getCloud().getSlaveUrl(), null, "/local/")});
        TaskGroup taskGroup = new TaskGroup("jenkins-slave-taskgroup", 1, new Task[]{task}, new RestartPolicy(0, 10000000000L, 1000000000L, "fail"), new EphemeralDisk(template.getDisk(), false, false));
        Job job = new Job(name, name, template.getRegion(), "batch", template.getPriority(), template.getDatacenters().split(","), new TaskGroup[]{taskGroup});
        Gson gson = new Gson();
        JsonObject jobJson = new JsonObject();
        jobJson.add("Job", gson.toJsonTree((Object)job));
        return gson.toJson((JsonElement)jobJson);
    }
}

