/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeUtil;
import org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger.NodeLabelBuildParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class AllNodesForLabelBuildParameterFactory
extends AbstractBuildParameterFactory {
    public final String name;
    public final String nodeLabel;
    public final boolean ignoreOfflineNodes;
    private static final Function<Node, String> SELF_LABEL_FUNCTION = new Function<Node, String>(){

        @Override
        public String apply(Node node) {
            return node != null && node.getSelfLabel() != null ? node.getSelfLabel().getName() : null;
        }
    };

    @DataBoundConstructor
    public AllNodesForLabelBuildParameterFactory(String name, String nodeLabel, boolean ignoreOfflineNodes) {
        this.name = name;
        this.nodeLabel = nodeLabel;
        this.ignoreOfflineNodes = ignoreOfflineNodes;
    }

    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        String labelExpanded = this.nodeLabel;
        try {
            labelExpanded = TokenMacro.expandAll(build, (TaskListener)listener, (String)labelExpanded);
        }
        catch (MacroEvaluationException e) {
            labelExpanded = this.nodeLabel;
            e.printStackTrace(listener.getLogger());
        }
        listener.getLogger().println("Getting all nodes with label: " + labelExpanded);
        Set nodes = Jenkins.getActiveInstance().getLabel(labelExpanded).getNodes();
        ArrayList<AbstractBuildParameters> params = new ArrayList<AbstractBuildParameters>();
        if (nodes == null || nodes.isEmpty()) {
            listener.getLogger().println("Found no nodes");
            params.add(new NodeLabelBuildParameter(this.name, labelExpanded));
        } else {
            List selfLabels = nodes.stream().map(SELF_LABEL_FUNCTION).collect(Collectors.toList());
            listener.getLogger().println("Found nodes: " + String.valueOf(selfLabels));
            for (Node node : nodes) {
                String nodeSelfLabel = node.getSelfLabel().getName();
                if (this.ignoreOfflineNodes) {
                    if (NodeUtil.isNodeOnline(nodeSelfLabel)) {
                        params.add(new NodeLabelBuildParameter(this.name, nodeSelfLabel));
                        continue;
                    }
                    listener.getLogger().println(Messages.NodeListBuildParameterFactory_skippOfflineNode(nodeSelfLabel));
                    continue;
                }
                params.add(new NodeLabelBuildParameter(this.name, nodeSelfLabel));
            }
            if (params.isEmpty()) {
                params.add(new NodeLabelBuildParameter(this.name, labelExpanded));
                listener.getLogger().println(Messages.NodeListBuildParameterFactory_noOnlineNodeFound(labelExpanded));
            }
        }
        return params;
    }

    public boolean isIgnoreOfflineNodes() {
        return this.ignoreOfflineNodes;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return Messages.AllNodesForLabelBuildParameterFactory_displayName();
        }
    }
}

