/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.labels.LabelExpression;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelParameterValue;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.MultipleNodeDescribingParameterDefinition;
import org.jvnet.jenkins.plugins.nodelabelparameter.node.AllNodeEligibility;
import org.jvnet.jenkins.plugins.nodelabelparameter.node.IgnoreOfflineNodeEligibility;
import org.jvnet.jenkins.plugins.nodelabelparameter.node.NodeEligibility;
import org.jvnet.jenkins.plugins.nodelabelparameter.wrapper.TriggerNextBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class LabelParameterDefinition
extends SimpleParameterDefinition
implements MultipleNodeDescribingParameterDefinition {
    private static final long serialVersionUID = 1L;
    public final String defaultValue;
    private boolean allNodesMatchingLabel;
    @Deprecated
    private transient boolean ignoreOfflineNodes;
    private String triggerIfResult;
    private NodeEligibility nodeEligibility;

    @DataBoundConstructor
    public LabelParameterDefinition(String name, String description, String defaultValue, boolean allNodesMatchingLabel, NodeEligibility nodeEligibility, String triggerIfResult) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.allNodesMatchingLabel = allNodesMatchingLabel;
        this.nodeEligibility = nodeEligibility == null ? new AllNodeEligibility() : nodeEligibility;
        this.triggerIfResult = StringUtils.isBlank((String)triggerIfResult) ? "allCases" : triggerIfResult;
    }

    @Deprecated
    public LabelParameterDefinition(String name, String description, String defaultValue, boolean allNodesMatchingLabel, boolean ignoreOfflineNodes, String triggerIfResult) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.allNodesMatchingLabel = allNodesMatchingLabel;
        this.nodeEligibility = ignoreOfflineNodes ? new IgnoreOfflineNodeEligibility() : new AllNodeEligibility();
        this.triggerIfResult = StringUtils.isBlank((String)triggerIfResult) ? "allCases" : triggerIfResult;
    }

    @Deprecated
    public LabelParameterDefinition(String name, String description, String defaultValue) {
        this(name, description, defaultValue, false, false, "allCases");
    }

    public SimpleParameterDefinition copyWithDefaultValue(ParameterValue defaultValueObj) {
        if (defaultValueObj instanceof LabelParameterValue) {
            LabelParameterValue value = (LabelParameterValue)defaultValueObj;
            return new LabelParameterDefinition(this.getName(), this.getDescription(), value.getLabel(), this.allNodesMatchingLabel, this.ignoreOfflineNodes, this.triggerIfResult);
        }
        return this;
    }

    public LabelParameterValue getDefaultParameterValue() {
        return new LabelParameterValue(this.getName(), this.defaultValue, this.allNodesMatchingLabel, this.nodeEligibility);
    }

    public boolean isAllNodesMatchingLabel() {
        return this.allNodesMatchingLabel;
    }

    @Override
    public NodeEligibility getNodeEligibility() {
        return this.nodeEligibility;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        LabelParameterValue value = (LabelParameterValue)((Object)req.bindJSON(LabelParameterValue.class, jo));
        value.setDescription(this.getDescription());
        if (StringUtils.isBlank((String)value.getLabel())) {
            String label = jo.optString("value");
            value.setLabel(label);
        }
        value.computeNextLabels(this.allNodesMatchingLabel, this.nodeEligibility);
        return value;
    }

    public ParameterValue createValue(String str) {
        return new LabelParameterValue(this.getName(), str, this.allNodesMatchingLabel, this.nodeEligibility);
    }

    @Override
    public String getTriggerIfResult() {
        return this.triggerIfResult;
    }

    public boolean isTriggerConcurrentBuilds() {
        return "allCases".equals(this.triggerIfResult);
    }

    @Override
    public void validateBuild(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (build.getProject().isConcurrentBuild() && !this.isTriggerConcurrentBuilds()) {
            String msg = Messages.BuildWrapper_param_not_concurrent(this.getName());
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public TriggerNextBuildWrapper createBuildWrapper() {
        if (this.isAllNodesMatchingLabel()) {
            return new TriggerNextBuildWrapper(this);
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Label";
        }

        public String getHelpFile() {
            return "/plugin/nodelabelparameter/labelparam.html";
        }

        public AutoCompletionCandidates doAutoCompleteDefaultValue(@QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            for (Label l : Jenkins.getActiveInstance().getLabels()) {
                String label = l.getExpression();
                if (!StringUtils.containsIgnoreCase((String)label, (String)value)) continue;
                candidates.add(label);
            }
            return candidates;
        }

        public FormValidation doCheckDefaultValue(@QueryParameter String value) {
            if (value.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int matchingNodeCount = this.getNodesForLabel(value).size();
                return matchingNodeCount == 0 ? FormValidation.warning((String)Messages.NodeLabelParameterDefinition_noNodeMatched(value)) : FormValidation.ok();
            }
            catch (ANTLRException e) {
                return FormValidation.error((String)Messages.NodeLabelParameterDefinition_labelExpressionNotValid(value, e.getMessage()));
            }
        }

        public FormValidation doListNodesForLabel(@QueryParameter(value="label") String label) throws ServletException {
            if (StringUtils.isBlank((String)label)) {
                return FormValidation.error((String)Messages.LabelParameterDefinition_labelRequired());
            }
            try {
                Set<Node> nodes = this.getNodesForLabel(label);
                if (nodes.isEmpty()) {
                    return FormValidation.warning((String)Messages.NodeLabelParameterDefinition_noNodeMatched(label));
                }
                List nodeNames = nodes.stream().map(new NodeDescFunction()).collect(Collectors.toList());
                String html = String.join((CharSequence)"</li><li>", nodeNames);
                return FormValidation.okWithMarkup((String)("<b>" + Messages.LabelParameterDefinition_matchingNodes() + "</b><ul><li>" + html + "</li></ul>"));
            }
            catch (ANTLRException e) {
                return FormValidation.error((String)Messages.NodeLabelParameterDefinition_labelExpressionNotValid(label, e.getMessage()));
            }
        }

        private Set<Node> getNodesForLabel(String labelExp) throws ANTLRException {
            Label label = LabelExpression.parseExpression((String)labelExp);
            return label.getNodes();
        }

        public NodeEligibility getDefaultNodeEligibility() {
            return new AllNodeEligibility();
        }

        private static final class NodeDescFunction
        implements Function<Node, String> {
            private NodeDescFunction() {
            }

            @Override
            public String apply(Node n) {
                return n != null && StringUtils.isNotBlank((String)n.getNodeName()) ? n.getNodeName() : "master";
            }
        }
    }
}

