/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter.wrapper;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelParameterValue;
import org.jvnet.jenkins.plugins.nodelabelparameter.MultipleNodeDescribingParameterDefinition;
import org.jvnet.jenkins.plugins.nodelabelparameter.NextLabelCause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerNextBuildWrapper
extends BuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(TriggerNextBuildWrapper.class.getName());
    private final MultipleNodeDescribingParameterDefinition parameterDefinition;

    public TriggerNextBuildWrapper(MultipleNodeDescribingParameterDefinition parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ParametersAction origParamsAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (origParamsAction == null) {
            return new BuildWrapper.Environment(){};
        }
        this.parameterDefinition.validateBuild(build, launcher, listener);
        if (build.getProject().isConcurrentBuild()) {
            this.triggerAllBuildsConcurrent(build, listener);
            return new BuildWrapper.Environment(){};
        }
        return new TriggerNextBuildEnvironment();
    }

    private void triggerAllBuildsConcurrent(AbstractBuild<?, ?> build, BuildListener listener) {
        ArrayList<String> newBuildNodes = new ArrayList<String>();
        String parmaName = null;
        ParametersAction origParamsAction = (ParametersAction)build.getAction(ParametersAction.class);
        List origParams = origParamsAction.getParameters();
        ArrayList<ParameterValue> newPrams = new ArrayList<ParameterValue>();
        for (ParameterValue parameterValue : origParams) {
            if (parameterValue instanceof LabelParameterValue) {
                LabelParameterValue origNodeParam = (LabelParameterValue)parameterValue;
                parmaName = origNodeParam.getName();
                List<String> nextNodes = origNodeParam.getNextLabels();
                if (nextNodes == null) continue;
                listener.getLogger().print("next nodes: " + nextNodes);
                newBuildNodes.addAll(nextNodes);
                continue;
            }
            newPrams.add(parameterValue);
        }
        for (String nodeName : newBuildNodes) {
            ArrayList<String> singleNodeList = new ArrayList<String>();
            singleNodeList.add(nodeName);
            LabelParameterValue pValue = new LabelParameterValue(parmaName, singleNodeList, this.parameterDefinition.getNodeEligibility());
            ArrayList<LabelParameterValue> copies = new ArrayList<LabelParameterValue>(newPrams);
            copies.add(pValue);
            listener.getLogger().print("schedule build on node " + nodeName);
            build.getProject().scheduleBuild(0, (Cause)new NextLabelCause(nodeName, (Run<?, ?>)build), new Action[]{new ParametersAction(copies)});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TriggerNextBuildEnvironment
    extends BuildWrapper.Environment {
        private TriggerNextBuildEnvironment() {
            super((BuildWrapper)TriggerNextBuildWrapper.this);
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            this.triggerBuilds(build, listener);
            return true;
        }

        private void triggerBuilds(AbstractBuild<?, ?> build, BuildListener listener) {
            ParametersAction origParamsAction = (ParametersAction)build.getAction(ParametersAction.class);
            List origParams = origParamsAction.getParameters();
            ArrayList<ParameterValue> newPrams = new ArrayList<ParameterValue>();
            boolean triggerNewBuild = false;
            NextLabelCause nextLabelCause = null;
            for (ParameterValue parameterValue : origParams) {
                if (parameterValue instanceof LabelParameterValue) {
                    LabelParameterValue origNodePram = (LabelParameterValue)parameterValue;
                    List<String> nextNodes = origNodePram.getNextLabels();
                    if (nextNodes == null || nextNodes.isEmpty() || !this.shouldScheduleNextJob(build.getResult(), TriggerNextBuildWrapper.this.parameterDefinition.getTriggerIfResult())) continue;
                    LabelParameterValue newNodeParam = new LabelParameterValue(origNodePram.getName(), nextNodes, TriggerNextBuildWrapper.this.parameterDefinition.getNodeEligibility());
                    newPrams.add(newNodeParam);
                    String nextLabel = newNodeParam.getLabel();
                    if (nextLabel != null) {
                        listener.getLogger().print("schedule single build on node " + nextLabel);
                        nextLabelCause = new NextLabelCause(nextLabel, (Run<?, ?>)build);
                        triggerNewBuild = true;
                        continue;
                    }
                    listener.getLogger().print("ERROR: can't trigger next build because next label could not be determined!");
                    continue;
                }
                newPrams.add(parameterValue);
            }
            if (triggerNewBuild) {
                build.getProject().scheduleBuild(0, nextLabelCause, new Action[]{new ParametersAction(newPrams)});
            }
        }

        private boolean shouldScheduleNextJob(Result buildResult, String runIfResult) {
            if (runIfResult == null) {
                runIfResult = "allCases";
            }
            if (runIfResult.equals("allCases")) {
                return true;
            }
            if ("success".equals(runIfResult)) {
                return buildResult == null || buildResult.isBetterOrEqualTo(Result.SUCCESS);
            }
            if ("unstable".equals(runIfResult)) {
                return buildResult == null || buildResult.isBetterOrEqualTo(Result.UNSTABLE);
            }
            return false;
        }
    }
}

