/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter.wrapper;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelParameterValue;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.NextLabelCause;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterDefinition;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterValue;

public class TriggerNextBuildWrapper
extends BuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(TriggerNextBuildWrapper.class.getName());
    private final String triggerIfResult;
    private final NodeParameterDefinition nodeParameterDefinition;

    public TriggerNextBuildWrapper(NodeParameterDefinition nodeParameterDefinition) {
        this.nodeParameterDefinition = nodeParameterDefinition;
        this.triggerIfResult = nodeParameterDefinition.getTriggerIfResult();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ParametersAction origParamsAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (origParamsAction == null) {
            return new BuildWrapper.Environment(){};
        }
        if (build.getProject().isConcurrentBuild() && !this.nodeParameterDefinition.isTriggerConcurrentBuilds()) {
            String msg = Messages.BuildWrapper_param_not_concurrent(this.nodeParameterDefinition.getName());
            LOGGER.severe(msg);
            throw new IllegalStateException(msg);
        }
        if (!build.getProject().isConcurrentBuild() && this.nodeParameterDefinition.isTriggerConcurrentBuilds()) {
            String msg = Messages.BuildWrapper_project_not_concurrent(this.nodeParameterDefinition.getName());
            LOGGER.severe(msg);
            throw new IllegalStateException(msg);
        }
        if (build.getProject().isConcurrentBuild()) {
            this.triggerAllBuildsConcurrent(build, listener);
            return new BuildWrapper.Environment(){};
        }
        return new TriggerNextBuildEnvironment();
    }

    private void triggerAllBuildsConcurrent(AbstractBuild build, BuildListener listener) {
        ArrayList<String> newBuildNodes = new ArrayList<String>();
        String parmaName = null;
        ParametersAction origParamsAction = (ParametersAction)build.getAction(ParametersAction.class);
        List origParams = origParamsAction.getParameters();
        ArrayList<ParameterValue> newPrams = new ArrayList<ParameterValue>();
        for (ParameterValue parameterValue : origParams) {
            if (parameterValue instanceof LabelParameterValue) {
                if (!(parameterValue instanceof NodeParameterValue)) continue;
                NodeParameterValue origNodeParam = (NodeParameterValue)parameterValue;
                parmaName = origNodeParam.getName();
                List<String> nextNodes = origNodeParam.getNextLabels();
                if (nextNodes == null) continue;
                listener.getLogger().print("next nodes: " + nextNodes);
                newBuildNodes.addAll(nextNodes);
                continue;
            }
            newPrams.add(parameterValue);
        }
        for (String nodeName : newBuildNodes) {
            ArrayList<String> singleNodeList = new ArrayList<String>();
            singleNodeList.add(nodeName);
            NodeParameterValue nodeParameterValue = new NodeParameterValue(parmaName, singleNodeList, this.nodeParameterDefinition.isIgnoreOfflineNodes());
            ArrayList<NodeParameterValue> copies = new ArrayList<NodeParameterValue>(newPrams);
            copies.add(nodeParameterValue);
            listener.getLogger().print("schedule build on node " + nodeName);
            build.getProject().scheduleBuild(0, (Cause)new NextLabelCause(nodeName, (Run<?, ?>)build), new Action[]{new ParametersAction(copies)});
        }
    }

    private class TriggerNextBuildEnvironment
    extends BuildWrapper.Environment {
        private TriggerNextBuildEnvironment() {
            super((BuildWrapper)TriggerNextBuildWrapper.this);
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            this.triggerBuilds(build, listener);
            return true;
        }

        private void triggerBuilds(AbstractBuild build, BuildListener listener) {
            ParametersAction origParamsAction = (ParametersAction)build.getAction(ParametersAction.class);
            List origParams = origParamsAction.getParameters();
            ArrayList<ParameterValue> newPrams = new ArrayList<ParameterValue>();
            boolean triggerNewBuild = false;
            NextLabelCause nextLabelCause = null;
            for (ParameterValue parameterValue : origParams) {
                if (parameterValue instanceof LabelParameterValue) {
                    NodeParameterValue origNodePram;
                    List<String> nextNodes;
                    if (!(parameterValue instanceof NodeParameterValue) || (nextNodes = (origNodePram = (NodeParameterValue)parameterValue).getNextLabels()) == null || nextNodes.isEmpty() || !this.shouldScheduleNextJob(build.getResult(), TriggerNextBuildWrapper.this.triggerIfResult)) continue;
                    NodeParameterValue newNodeParam = new NodeParameterValue(origNodePram.getName(), nextNodes, TriggerNextBuildWrapper.this.nodeParameterDefinition.isIgnoreOfflineNodes());
                    newPrams.add(newNodeParam);
                    String nextLabel = newNodeParam.getLabel();
                    if (nextLabel != null) {
                        listener.getLogger().print("schedule single build on node " + nextLabel);
                        nextLabelCause = new NextLabelCause(nextLabel, (Run<?, ?>)build);
                        triggerNewBuild = true;
                        continue;
                    }
                    LOGGER.severe("can't trigger next build because next label could not be determined!");
                    continue;
                }
                newPrams.add(parameterValue);
            }
            if (triggerNewBuild) {
                build.getProject().scheduleBuild(0, nextLabelCause, new Action[]{new ParametersAction(newPrams)});
            }
        }

        private boolean shouldScheduleNextJob(Result buildResult, String runIfResult) {
            if (runIfResult == null) {
                runIfResult = "allCases";
            }
            if (runIfResult.equals("allCases")) {
                return true;
            }
            if (runIfResult.equals("success")) {
                return buildResult == null || buildResult.isBetterOrEqualTo(Result.SUCCESS);
            }
            if (runIfResult.equals("unstable")) {
                return buildResult == null || buildResult.isBetterOrEqualTo(Result.UNSTABLE);
            }
            return false;
        }
    }
}

