/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger.NodeLabelBuildParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class NodeListBuildParameterFactory
extends AbstractBuildParameterFactory {
    private static final Logger LOGGER = Logger.getLogger(NodeListBuildParameterFactory.class.getName());
    public final String name;
    public final String nodeListString;

    @DataBoundConstructor
    public NodeListBuildParameterFactory(String name, String nodeListString) {
        this.name = name;
        this.nodeListString = nodeListString;
    }

    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        String nodeListStringExpanded = this.nodeListString;
        try {
            nodeListStringExpanded = TokenMacro.expandAll(build, (TaskListener)listener, (String)nodeListStringExpanded);
        }
        catch (MacroEvaluationException e) {
            nodeListStringExpanded = this.nodeListString;
            e.printStackTrace(listener.getLogger());
        }
        ArrayList<AbstractBuildParameters> params = new ArrayList<AbstractBuildParameters>();
        if (StringUtils.isBlank((String)nodeListStringExpanded)) {
            listener.getLogger().println("[WARN] no node name was given! [" + this.nodeListString + "], can't trigger other project");
        } else {
            String[] nodes = nodeListStringExpanded.trim().split(",");
            if (nodes == null || nodes.length == 0) {
                params.add(new NodeLabelBuildParameter(this.name, nodeListStringExpanded));
            } else {
                for (String node : nodes) {
                    params.add(new NodeLabelBuildParameter(this.name, node));
                }
            }
        }
        return params;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return Messages.NodeListBuildParameterFactory_displayName();
        }

        public AutoCompletionCandidates doAutoCompleteNodeListString(@QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            for (Node n : Jenkins.get().getNodes()) {
                candidates.add(n.getSelfLabel().getExpression());
            }
            return candidates;
        }

        public FormValidation doCheckNodeListString(@AncestorInPath Item project, @QueryParameter String value) {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull((String)value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String nodeName = tokens.nextToken().trim();
                if (!StringUtils.isNotBlank((String)nodeName)) continue;
                Node node = Jenkins.get().getNode(nodeName);
                if (node == null) {
                    return FormValidation.error((String)Messages.NodeListBuildParameterFactory_nodeNotFound(nodeName));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error((String)Messages.NodeListBuildParameterFactory_nodeNotDefined());
            }
            return FormValidation.ok();
        }
    }
}

