/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.MultipleNodeDescribingParameterDefinition;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterValue;
import org.jvnet.jenkins.plugins.nodelabelparameter.node.AllNodeEligibility;
import org.jvnet.jenkins.plugins.nodelabelparameter.node.IgnoreOfflineNodeEligibility;
import org.jvnet.jenkins.plugins.nodelabelparameter.node.NodeEligibility;
import org.jvnet.jenkins.plugins.nodelabelparameter.wrapper.TriggerNextBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class NodeParameterDefinition
extends SimpleParameterDefinition
implements MultipleNodeDescribingParameterDefinition {
    private static final long serialVersionUID = 1L;
    public final List<String> allowedSlaves;
    private List<String> defaultSlaves;
    @Deprecated
    public transient String defaultValue;
    private String triggerIfResult;
    private boolean allowMultiNodeSelection;
    private boolean triggerConcurrentBuilds;
    @Deprecated
    private boolean ignoreOfflineNodes;
    private NodeEligibility nodeEligibility;

    @DataBoundConstructor
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Low risk")
    public NodeParameterDefinition(String name, String description, List<String> defaultSlaves, List<String> allowedSlaves, String triggerIfResult, NodeEligibility nodeEligibility) {
        super(name, description);
        this.allowedSlaves = allowedSlaves;
        this.defaultSlaves = defaultSlaves;
        if ("multiSelectionDisallowed".equals(triggerIfResult)) {
            this.allowMultiNodeSelection = false;
            this.triggerConcurrentBuilds = false;
        } else if ("allowMultiSelectionForConcurrentBuilds".equals(triggerIfResult)) {
            this.allowMultiNodeSelection = true;
            this.triggerConcurrentBuilds = true;
        } else {
            this.allowMultiNodeSelection = true;
            this.triggerConcurrentBuilds = false;
        }
        this.triggerIfResult = triggerIfResult;
        this.nodeEligibility = nodeEligibility == null ? new AllNodeEligibility() : nodeEligibility;
    }

    @Deprecated
    public NodeParameterDefinition(String name, String description, List<String> defaultSlaves, List<String> allowedSlaves, String triggerIfResult, boolean ignoreOfflineNodes) {
        this(name, description, defaultSlaves, allowedSlaves, triggerIfResult, ignoreOfflineNodes ? new IgnoreOfflineNodeEligibility() : new AllNodeEligibility());
    }

    @Deprecated
    public NodeParameterDefinition(String name, String description, String defaultValue, List<String> allowedSlaves, String triggerIfResult) {
        this(name, description, new ArrayList<String>(), allowedSlaves, triggerIfResult, false);
        if (this.allowedSlaves != null && this.allowedSlaves.contains(defaultValue)) {
            this.allowedSlaves.remove(defaultValue);
            this.allowedSlaves.add(0, defaultValue);
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Low risk")
    public List<String> getDefaultSlaves() {
        return this.defaultSlaves;
    }

    public NodeParameterValue getDefaultParameterValue() {
        return new NodeParameterValue(this.getName(), this.getDefaultSlaves(), this.nodeEligibility);
    }

    public ParameterValue createValue(String value) {
        return new NodeParameterValue(this.getName(), this.getDescription(), value);
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValueObj) {
        return this;
    }

    public List<String> getAllowedNodesOrAll() {
        List<String> slaves = this.allowedSlaves == null || this.allowedSlaves.isEmpty() || this.allowedSlaves.contains("ALL (no restriction)") ? NodeParameterDefinition.getNodeNames() : this.allowedSlaves;
        Collections.sort(slaves, NodeNameComparator.INSTANCE);
        String controllerLabel = Jenkins.get().getSelfLabel().getName();
        if (slaves.contains(controllerLabel)) {
            NodeParameterDefinition.moveMasterToFirstPosition(slaves);
        }
        return slaves;
    }

    @Override
    public String getTriggerIfResult() {
        return this.triggerIfResult;
    }

    @Override
    public NodeEligibility getNodeEligibility() {
        return this.nodeEligibility;
    }

    public static List<String> getSlaveNamesForSelection() {
        List<String> slaveNames = NodeParameterDefinition.getNodeNames();
        slaveNames.add(0, "ALL (no restriction)");
        return slaveNames;
    }

    public static List<String> getSlaveNames() {
        return NodeParameterDefinition.getNodeNames();
    }

    private static List<String> getNodeNames() {
        ArrayList<String> names = new ArrayList<String>();
        List nodes = Jenkins.get().getNodes();
        for (Node node : nodes) {
            String nodeName = node.getNodeName();
            if (!StringUtils.isNotBlank((String)nodeName)) continue;
            names.add(nodeName);
        }
        Collections.sort(names, NodeNameComparator.INSTANCE);
        NodeParameterDefinition.moveMasterToFirstPosition(names);
        return names;
    }

    private static void moveMasterToFirstPosition(List<String> nodeList) {
        String controllerLabel = Jenkins.get().getSelfLabel().getName();
        if (controllerLabel.equals("master")) {
            nodeList.remove("master");
            nodeList.add(0, "master");
        } else {
            nodeList.remove(controllerLabel);
            nodeList.add(0, controllerLabel);
        }
    }

    @Override
    public void validateBuild(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (build.getProject().isConcurrentBuild() && !this.isTriggerConcurrentBuilds()) {
            String msg = Messages.BuildWrapper_param_not_concurrent(this.getName());
            throw new IllegalStateException(msg);
        }
        if (!build.getProject().isConcurrentBuild() && this.isTriggerConcurrentBuilds()) {
            String msg = Messages.BuildWrapper_project_not_concurrent(this.getName());
            throw new IllegalStateException(msg);
        }
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        String name = jo.getString("name");
        Object joValue = jo.get("value") == null ? (jo.get("labels") == null ? jo.get("label") : jo.get("labels")) : jo.get("value");
        ArrayList<String> nodes = new ArrayList<String>();
        if (joValue instanceof String) {
            nodes.add((String)joValue);
        } else if (joValue instanceof JSONArray) {
            JSONArray ja = (JSONArray)joValue;
            for (Object strObj : ja) {
                nodes.add((String)strObj);
            }
        }
        NodeParameterValue value = new NodeParameterValue(name, nodes, this.nodeEligibility);
        value.setDescription(this.getDescription());
        return value;
    }

    public boolean getAllowMultiNodeSelection() {
        return this.allowMultiNodeSelection;
    }

    public boolean isTriggerConcurrentBuilds() {
        return this.triggerConcurrentBuilds;
    }

    public Object readResolve() {
        if (this.defaultValue != null) {
            if (this.defaultSlaves == null) {
                this.defaultSlaves = new ArrayList<String>();
            }
            this.defaultSlaves.add(this.defaultValue);
        }
        if (this.nodeEligibility == null) {
            this.nodeEligibility = this.ignoreOfflineNodes ? new IgnoreOfflineNodeEligibility() : new AllNodeEligibility();
        }
        return this;
    }

    @Override
    public TriggerNextBuildWrapper createBuildWrapper() {
        if (this.getAllowMultiNodeSelection()) {
            return new TriggerNextBuildWrapper(this);
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Node";
        }

        public String getHelpFile() {
            return "/plugin/nodelabelparameter/nodeparam.html";
        }

        public NodeEligibility getDefaultNodeEligibility() {
            return new AllNodeEligibility();
        }
    }

    private static final class NodeNameComparator
    implements Comparator<String> {
        public static final NodeNameComparator INSTANCE = new NodeNameComparator();

        private NodeNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}

