/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.Extension;
import hudson.model.ComputerSet;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterValue;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeParameterDefinition
extends SimpleParameterDefinition {
    private static final long serialVersionUID = 1L;
    public static final String ALL_NODES = "ALL (no restriction)";
    public final List<String> allowedSlaves;
    public final String defaultValue;
    private String triggerIfResult;
    private boolean allowMultiNodeSelection;
    private boolean triggerConcurrentBuilds;

    @DataBoundConstructor
    public NodeParameterDefinition(String name, String description, String defaultValue, List<String> allowedSlaves, String triggerIfResult) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.allowedSlaves = allowedSlaves;
        if (this.allowedSlaves != null && this.allowedSlaves.contains(defaultValue)) {
            this.allowedSlaves.remove(defaultValue);
            this.allowedSlaves.add(0, defaultValue);
        }
        if ("multiSelectionDisallowed".equals(triggerIfResult)) {
            this.allowMultiNodeSelection = false;
            this.triggerConcurrentBuilds = false;
        } else if ("allowMultiSelectionForConcurrentBuilds".equals(triggerIfResult)) {
            this.allowMultiNodeSelection = true;
            this.triggerConcurrentBuilds = true;
        } else {
            this.allowMultiNodeSelection = true;
            this.triggerConcurrentBuilds = false;
        }
        this.triggerIfResult = triggerIfResult;
    }

    public NodeParameterValue getDefaultParameterValue() {
        NodeParameterValue v = new NodeParameterValue(this.getName(), this.getDescription(), this.defaultValue);
        return v;
    }

    public ParameterValue createValue(String value) {
        return new NodeParameterValue(this.getName(), value, this.getDescription());
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValueObj) {
        if (defaultValueObj instanceof NodeParameterValue) {
            NodeParameterValue value = (NodeParameterValue)defaultValueObj;
            return new NodeParameterDefinition(this.getName(), this.getDescription(), value.getLabel(), NodeParameterDefinition.getSlaveNames(), this.triggerIfResult);
        }
        return this;
    }

    public List<String> getAllowedNodesOrAll() {
        List<String> slaves = this.allowedSlaves == null || this.allowedSlaves.isEmpty() || this.allowedSlaves.contains(ALL_NODES) ? NodeParameterDefinition.getSlaveNames() : this.allowedSlaves;
        Collections.sort(slaves);
        slaves.remove(this.defaultValue);
        slaves.add(0, this.defaultValue);
        return slaves;
    }

    public String getTriggerIfResult() {
        return this.triggerIfResult;
    }

    public static List<String> getSlaveNamesForSelection() {
        List<String> slaveNames = NodeParameterDefinition.getSlaveNames();
        slaveNames.add(0, ALL_NODES);
        return slaveNames;
    }

    public static List<String> getSlaveNames() {
        ComputerSet computers = Hudson.getInstance().getComputer();
        List slaveNames = computers.get_slaveNames();
        ArrayList<String> test = new ArrayList<String>();
        test.addAll(slaveNames);
        if (!test.contains("master")) {
            test.add("master");
        }
        return test;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        String name = jo.getString("name");
        Object joValue = jo.get("value") == null ? jo.get("labels") : jo.get("value");
        ArrayList<String> nodes = new ArrayList<String>();
        if (joValue instanceof String) {
            nodes.add((String)joValue);
        } else if (joValue instanceof JSONArray) {
            JSONArray ja = (JSONArray)joValue;
            for (Object strObj : ja) {
                nodes.add((String)strObj);
            }
        }
        NodeParameterValue value = new NodeParameterValue(name, nodes);
        value.setDescription(this.getDescription());
        return value;
    }

    public boolean getAllowMultiNodeSelection() {
        return this.allowMultiNodeSelection;
    }

    public boolean isTriggerConcurrentBuilds() {
        return this.triggerConcurrentBuilds;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Node";
        }

        public String getHelpFile() {
            return "/plugin/nodelabelparameter/nodeparam.html";
        }
    }
}

