/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Label;
import hudson.model.ParameterValue;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.SubTask;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelBadgeAction;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelParameterValue
extends ParameterValue {
    @Exported(visibility=3)
    private String label;

    public LabelParameterValue(String name) {
        super(name);
    }

    @DataBoundConstructor
    public LabelParameterValue(String name, String label) {
        super(name);
        this.label = label;
    }

    public LabelParameterValue(String name, String description, String label) {
        super(name, description);
        this.label = label;
    }

    public Label getAssignedLabel(SubTask task) {
        return new LabelAtom(this.label);
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return LabelParameterValue.this.name.equals(name) ? LabelParameterValue.this.label : null;
            }
        };
    }

    public String toString() {
        return "[LabelParameterValue: " + this.name + "=" + this.label + "]";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        build.addAction((Action)new LabelBadgeAction(this.getLabel(), Messages.LabelBadgeAction_label_tooltip(this.getLabel())));
        return null;
    }
}

