/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.Extension;
import hudson.model.ComputerSet;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterValue;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeParameterDefinition
extends SimpleParameterDefinition {
    private static final long serialVersionUID = 1L;
    public static final String ALL_NODES = "ALL (no restriction)";
    public final List<String> allowedSlaves;
    public final String defaultValue;

    @DataBoundConstructor
    public NodeParameterDefinition(String name, String description, String defaultValue, List<String> allowedSlaves) {
        super(name, description);
        this.allowedSlaves = allowedSlaves;
        this.defaultValue = defaultValue;
    }

    public NodeParameterValue getDefaultParameterValue() {
        NodeParameterValue v = new NodeParameterValue(this.getName(), this.getDescription(), this.defaultValue);
        return v;
    }

    public ParameterValue createValue(String value) {
        return new NodeParameterValue(this.getName(), value, this.getDescription());
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValueObj) {
        if (defaultValueObj instanceof NodeParameterValue) {
            NodeParameterValue value = (NodeParameterValue)defaultValueObj;
            return new NodeParameterDefinition(this.getName(), this.getDescription(), value.label, NodeParameterDefinition.getSlaveNames());
        }
        return this;
    }

    public List<String> getAllowedNodesOrAll() {
        return this.allowedSlaves == null || this.allowedSlaves.isEmpty() || this.allowedSlaves.contains(ALL_NODES) ? NodeParameterDefinition.getSlaveNames() : this.allowedSlaves;
    }

    public static List<String> getSlaveNamesForSelection() {
        List<String> slaveNames = NodeParameterDefinition.getSlaveNames();
        slaveNames.add(0, ALL_NODES);
        return slaveNames;
    }

    public static List<String> getSlaveNames() {
        ComputerSet computers = Hudson.getInstance().getComputer();
        List slaveNames = computers.get_slaveNames();
        ArrayList<String> test = new ArrayList<String>();
        test.addAll(slaveNames);
        if (!test.contains("master")) {
            test.add("master");
        }
        return test;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        NodeParameterValue value = (NodeParameterValue)((Object)req.bindJSON(NodeParameterValue.class, jo));
        value.setDescription(this.getDescription());
        return value;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Node";
        }

        public String getHelpFile() {
            return "/plugin/nodelabelparameter/nodeparam.html";
        }
    }
}

