/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools.pathresolvers;

import java.text.MessageFormat;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.CPU;
import jenkins.plugins.nodejs.tools.InstallerPathResolver;
import jenkins.plugins.nodejs.tools.NodeJSVersion;
import jenkins.plugins.nodejs.tools.NodeJSVersionRange;
import jenkins.plugins.nodejs.tools.Platform;

public class LatestInstallerPathResolver
implements InstallerPathResolver {
    private static final String EXTENSION = "tar.gz";
    private static final String EXTENSION_ZIP = "zip";
    private static final String EXTENSION_MSI = "msi";
    private static final NodeJSVersionRange[] MSI_RANGES = new NodeJSVersionRange[]{new NodeJSVersionRange("[0, 4.5)"), new NodeJSVersionRange("[5, 6.2]")};

    @Override
    public String resolvePathFor(String version, Platform platform, CPU cpu) {
        String path = "";
        String os = null;
        boolean isMSI = false;
        String extension = switch (platform) {
            case Platform.WINDOWS -> {
                isMSI = this.isMSI(version);
                if (!isMSI) {
                    os = "win";
                    yield EXTENSION_ZIP;
                }
                yield EXTENSION_MSI;
            }
            case Platform.LINUX -> {
                os = "linux";
                yield EXTENSION;
            }
            case Platform.OSX -> {
                os = "darwin";
                yield EXTENSION;
            }
            case Platform.SUNOS -> {
                os = "sunos";
                yield EXTENSION;
            }
            case Platform.AIX -> {
                os = "aix";
                yield EXTENSION;
            }
            default -> throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedOS(version, platform.name()));
        };
        NodeJSVersion nodeVersion = NodeJSVersion.parseVersion(version);
        String arch = switch (cpu) {
            case CPU.i386 -> {
                if (platform == Platform.OSX && nodeVersion.compareTo(new NodeJSVersion(4, 0, 0)) >= 0 || (platform == Platform.SUNOS || platform == Platform.LINUX) && nodeVersion.compareTo(new NodeJSVersion(10, 0, 0)) >= 0) {
                    throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedArch(version, cpu.name(), platform.name()));
                }
                yield "x86";
            }
            case CPU.amd64 -> {
                if (platform == Platform.SUNOS && (new NodeJSVersionRange("[7, 7.5)").includes(nodeVersion) || nodeVersion.compareTo(new NodeJSVersion(0, 12, 18)) == 0 || nodeVersion.compareTo(new NodeJSVersion(14, 0, 0)) >= 0)) {
                    throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedArch(version, cpu.name(), platform.name()));
                }
                if (isMSI && nodeVersion.compareTo(new NodeJSVersion(4, 0, 0)) < 0) {
                    path = "x64/";
                }
                yield "x64";
            }
            case CPU.arm64 -> {
                if (nodeVersion.compareTo(new NodeJSVersion(4, 0, 0)) < 0) {
                    throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedArch(version, cpu.name(), platform.name()));
                }
                if (platform == Platform.OSX && nodeVersion.compareTo(new NodeJSVersion(16, 0, 0)) < 0) {
                    throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedArch(version, cpu.name(), platform.name()));
                }
                yield cpu.name();
            }
            case CPU.armv6l -> {
                if (nodeVersion.compareTo(new NodeJSVersion(12, 0, 0)) >= 0 || nodeVersion.compareTo(new NodeJSVersion(8, 6, 0)) == 0 || nodeVersion.compareTo(new NodeJSVersion(4, 0, 0)) < 0) {
                    throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedArch(version, cpu.name(), platform.name()));
                }
                yield cpu.name();
            }
            case CPU.armv7l -> {
                if (nodeVersion.compareTo(new NodeJSVersion(4, 0, 0)) < 0) {
                    throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedArch(version, cpu.name(), platform.name()));
                }
                yield cpu.name();
            }
            case CPU.ppc64 -> {
                if (platform != Platform.AIX || nodeVersion.compareTo(new NodeJSVersion(6, 7, 0)) < 0) {
                    throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedArch(version, cpu.name(), platform.name()));
                }
                yield cpu.name();
            }
            default -> throw new IllegalArgumentException(Messages.InstallerPathResolver_unsupportedArch(version, cpu.name(), "unknown"));
        };
        if (os == null) {
            return MessageFormat.format("{0}node-v{1}-{2}.{3}", path, version, arch, extension);
        }
        return MessageFormat.format("{0}node-v{1}-{2}-{3}.{4}", path, version, os, arch, extension);
    }

    public boolean isMSI(String version) {
        NodeJSVersion currentVersion = new NodeJSVersion(version);
        for (NodeJSVersionRange msiRange : MSI_RANGES) {
            if (!msiRange.includes(currentVersion)) continue;
            return true;
        }
        return false;
    }
}

