/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.configfiles;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NPMRegistry
extends AbstractDescribableImpl<NPMRegistry>
implements Serializable {
    private static final long serialVersionUID = -5199710867477461372L;
    private final String url;
    private final String scopes;
    private final String credentialsId;

    public NPMRegistry(@NonNull String url, String credentialsId, String scopes) {
        this.url = Util.fixEmpty((String)url);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        this.scopes = this.fixScope(Util.fixEmpty((String)scopes));
    }

    @DataBoundConstructor
    public NPMRegistry(@NonNull String url, String credentialsId, boolean hasScopes, String scopes) {
        this.url = Util.fixEmpty((String)url);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        this.scopes = hasScopes ? this.fixScope(Util.fixEmpty((String)scopes)) : null;
    }

    @Nullable
    private String fixScope(@Nullable String scope) {
        if (scope != null && scope.startsWith("@")) {
            return scope.substring(1);
        }
        return scope;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public String getScopes() {
        return this.scopes;
    }

    public boolean isHasScopes() {
        return this.scopes != null;
    }

    public List<String> getScopesAsList() {
        List<String> result = Collections.emptyList();
        if (this.isHasScopes()) {
            result = Arrays.asList(StringUtils.split((String)this.scopes));
        }
        return result;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void doVerify() throws VerifyConfigProviderException {
        DescriptorImpl descriptor = new DescriptorImpl();
        this.throwException(descriptor.doCheckUrl(this.getUrl()));
        this.throwException(descriptor.doCheckScopes(this.isHasScopes(), this.getScopes()));
    }

    private void throwException(FormValidation form) throws VerifyConfigProviderException {
        if (form.kind == FormValidation.Kind.ERROR) {
            throw new VerifyConfigProviderException(form.getLocalizedMessage());
        }
    }

    public String toString() {
        return "url: " + this.url + (String)(this.scopes != null ? " scopes: [" + this.scopes + "]" : "") + (String)(this.credentialsId != null ? " credentialId: " + this.credentialsId : "");
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<NPMRegistry> {
        private Pattern variableRegExp = Pattern.compile("\\$\\{.*\\}");

        public FormValidation doCheckScopes(@QueryParameter @CheckForNull boolean hasScopes, @QueryParameter @CheckForNull String scopes) {
            scopes = Util.fixEmptyAndTrim((String)scopes);
            if (hasScopes) {
                if (scopes == null) {
                    return FormValidation.error((String)Messages.NPMRegistry_DescriptorImpl_emptyScopes());
                }
                StringTokenizer st = new StringTokenizer(scopes);
                while (st.hasMoreTokens()) {
                    String aScope = st.nextToken();
                    if (!aScope.startsWith("@")) continue;
                    if (aScope.length() == 1) {
                        return FormValidation.error((String)Messages.NPMRegistry_DescriptorImpl_invalidScopes());
                    }
                    return FormValidation.warning((String)Messages.NPMRegistry_DescriptorImpl_invalidCharInScopes());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter @CheckForNull String url) {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)Messages.NPMRegistry_DescriptorImpl_emptyRegistryURL());
            }
            if (!this.variableRegExp.matcher(url).find() && DescriptorImpl.toURL(url) == null) {
                return FormValidation.error((String)Messages.NPMRegistry_DescriptorImpl_invalidRegistryURL());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item projectOrFolder, @QueryParameter String credentialsId, @QueryParameter String serverUrl) {
            CredentialsMatcher matcher;
            if (projectOrFolder == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || projectOrFolder != null && !projectOrFolder.hasPermission(Item.EXTENDED_READ) && !projectOrFolder.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)credentialsId)) {
                return FormValidation.warning((String)Messages.NPMRegistry_DescriptorImpl_emptyCredentialsId());
            }
            List domainRequirement = URIRequirementBuilder.fromUri((String)serverUrl).build();
            Authentication authentication = this.getAuthentication(projectOrFolder);
            if (CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)projectOrFolder, (Authentication)authentication, (List)domainRequirement, (CredentialsMatcher)(matcher = CredentialsMatchers.withId((String)credentialsId))).isEmpty() && CredentialsProvider.listCredentials(StringCredentials.class, (Item)projectOrFolder, (Authentication)authentication, (List)domainRequirement, (CredentialsMatcher)matcher).isEmpty()) {
                return FormValidation.error((String)Messages.NPMRegistry_DescriptorImpl_invalidCredentialsId());
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull ItemGroup<?> context, @AncestorInPath @CheckForNull Item projectOrFolder, @QueryParameter String credentialsId, @QueryParameter String url) {
            Permission permToCheck = projectOrFolder == null ? Jenkins.ADMINISTER : Item.CONFIGURE;
            Jenkins contextToCheck = projectOrFolder == null ? Jenkins.get() : projectOrFolder;
            credentialsId = StringUtils.trimToEmpty((String)credentialsId);
            if (!contextToCheck.hasPermission(permToCheck)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            Authentication authentication = this.getAuthentication(projectOrFolder);
            List domainRequirements = URIRequirementBuilder.fromUri((String)url).build();
            CredentialsMatcher either = CredentialsMatchers.either((CredentialsMatcher)CredentialsMatchers.instanceOf(StandardUsernameCredentials.class), (CredentialsMatcher)CredentialsMatchers.instanceOf(StringCredentials.class));
            Class<StandardCredentials> type = StandardCredentials.class;
            return new StandardListBoxModel().includeMatchingAs(authentication, context, type, domainRequirements, either).includeEmptyValue();
        }

        @NonNull
        protected Authentication getAuthentication(Item item) {
            return item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM;
        }

        public String getDisplayName() {
            return "";
        }

        private static URL toURL(String url) {
            URL result = null;
            String fixedURL = Util.fixEmptyAndTrim((String)url);
            if (fixedURL != null) {
                try {
                    return new URL(fixedURL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

