/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.configfiles.NPMConfig;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;

final class NodeJSDescriptorUtils {
    private NodeJSDescriptorUtils() {
    }

    @NonNull
    public static ListBoxModel getConfigs(@Nullable ItemGroup<?> context) {
        ListBoxModel items = new ListBoxModel();
        items.add(Messages.NPMConfig_default(), "");
        for (Config config : ConfigFiles.getConfigsInContext(context, NPMConfig.NPMConfigProvider.class)) {
            items.add(config.name, config.id);
        }
        return items;
    }

    public static FormValidation checkConfig(@Nullable ItemGroup<?> context, @CheckForNull String configId) {
        Config config;
        if (configId != null && (config = ConfigFiles.getByIdOrNull(context, (String)configId)) != null) {
            try {
                ((NPMConfig)config).doVerify();
            }
            catch (VerifyConfigProviderException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
        return FormValidation.ok();
    }
}

