/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Environment;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.NodeJSDescriptorUtils;
import jenkins.plugins.nodejs.NodeJSUtils;
import jenkins.plugins.nodejs.cache.CacheLocationLocator;
import jenkins.plugins.nodejs.cache.DefaultCacheLocationLocator;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.plugins.nodejs.tools.Platform;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.model.ConfigFile;
import org.jenkinsci.lib.configprovider.model.ConfigFileManager;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class NodeJSCommandInterpreter
extends CommandInterpreter {
    private final String nodeJSInstallationName;
    private String configId;
    private CacheLocationLocator cacheLocationStrategy;
    private transient String nodeExec;

    @DataBoundConstructor
    public NodeJSCommandInterpreter(String command, String nodeJSInstallationName) {
        this(command, nodeJSInstallationName, null);
    }

    public NodeJSCommandInterpreter(String command, String nodeJSInstallationName, String configId) {
        super(command);
        this.nodeJSInstallationName = Util.fixEmpty((String)nodeJSInstallationName);
        this.configId = Util.fixEmpty((String)configId);
        this.cacheLocationStrategy = new DefaultCacheLocationLocator();
    }

    public NodeJSInstallation getNodeJS() {
        return NodeJSUtils.getNodeJS(this.nodeJSInstallationName);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws InterruptedException {
        try {
            FilePath cacheLocation;
            EnvVars env = build.getEnvironment(listener);
            EnvVars newEnv = new EnvVars();
            NodeJSInstallation ni = this.getNodeJS();
            if (ni == null) {
                if (this.nodeJSInstallationName != null) {
                    throw new AbortException(Messages.NodeJSBuilders_noInstallationFound(this.nodeJSInstallationName));
                }
                this.nodeExec = (launcher.isUnix() ? Platform.LINUX : Platform.WINDOWS).nodeFileName;
            } else {
                Node node = build.getBuiltOn();
                if (node == null) {
                    throw new AbortException(Messages.NodeJSBuilders_nodeOffline());
                }
                ni = ni.forNode(node, listener);
                String exec = (ni = ni.forEnvironment(env)).getExecutable(launcher);
                if (exec == null) {
                    listener.fatalError(Messages.NodeJSBuilders_noExecutableFound(ni.getHome()));
                    return false;
                }
                ni.buildEnvVars(newEnv);
                env.overrideAll((Map)newEnv);
                this.nodeExec = ni.getExecutable(launcher);
                if (this.nodeExec == null) {
                    throw new AbortException(Messages.NodeJSBuilders_noExecutableFound(ni.getHome()));
                }
            }
            FilePath workspace = build.getWorkspace();
            if (workspace != null && (cacheLocation = this.getCacheLocationStrategy().locate(workspace)) != null) {
                newEnv.put("npm_config_cache", cacheLocation.getRemote());
            }
            if (this.configId != null) {
                ConfigFile cf = new ConfigFile(this.configId, null, true);
                FilePath configFile = ConfigFileManager.provisionConfigFile((ConfigFile)cf, (EnvVars)env, build, (FilePath)workspace, (TaskListener)listener, new ArrayList());
                newEnv.put("npm_config_userconfig", configFile.getRemote());
                build.addAction((Action)new CleanTempFilesAction(configFile.getRemote()));
            }
            build.getEnvironments().add((Object)Environment.create((EnvVars)newEnv));
        }
        catch (AbortException e) {
            listener.fatalError(e.getMessage());
            return false;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(Messages.NodeJSCommandInterpreter_commandFailed()));
        }
        return this.internalPerform(build, launcher, listener);
    }

    protected boolean internalPerform(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws InterruptedException {
        return super.perform(build, launcher, listener);
    }

    public String[] buildCommandLine(FilePath script) {
        if (this.nodeExec == null) {
            throw new IllegalStateException("Node executable not initialised");
        }
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{this.nodeExec, script.getRemote()});
        return args.toCommandArray();
    }

    protected String getContents() {
        return this.getCommand();
    }

    protected String getFileExtension() {
        return ".js";
    }

    public String getNodeJSInstallationName() {
        return this.nodeJSInstallationName;
    }

    public String getConfigId() {
        return this.configId;
    }

    @DataBoundSetter
    public void setConfigId(String configId) {
        this.configId = Util.fixEmpty((String)configId);
    }

    public CacheLocationLocator getCacheLocationStrategy() {
        return this.cacheLocationStrategy;
    }

    @DataBoundSetter
    public void setCacheLocationStrategy(CacheLocationLocator cacheLocationStrategy) {
        this.cacheLocationStrategy = cacheLocationStrategy == null ? new DefaultCacheLocationLocator() : cacheLocationStrategy;
    }

    private Object readResolve() {
        if (this.cacheLocationStrategy == null) {
            this.setCacheLocationStrategy(null);
        }
        return this;
    }

    @Symbol(value={"nodejsci"})
    @Extension
    public static final class NodeJsDescriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.NodeJSCommandInterpreter_displayName();
        }

        public String getHelpFile() {
            return "/plugin/nodejs/help.html";
        }

        public NodeJSInstallation[] getInstallations() {
            return NodeJSUtils.getInstallations();
        }

        public ListBoxModel doFillConfigIdItems(@AncestorInPath ItemGroup<?> context) {
            return NodeJSDescriptorUtils.getConfigs(context);
        }

        public FormValidation doCheckConfigId(@Nullable @AncestorInPath ItemGroup<?> context, @CheckForNull @QueryParameter String configId) {
            return NodeJSDescriptorUtils.checkConfig(context, configId);
        }
    }
}

