/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.CPU;
import jenkins.plugins.nodejs.tools.DetectionFailedException;
import jenkins.plugins.nodejs.tools.InstallerPathResolver;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.plugins.nodejs.tools.NodeJSVersion;
import jenkins.plugins.nodejs.tools.Platform;
import jenkins.plugins.tools.Installables;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class NodeJSInstaller
extends DownloadFromUrlInstaller {
    public static final String NPM_PACKAGES_RECORD_FILENAME = ".npmPackages";
    public static final int DEFAULT_NPM_PACKAGES_REFRESH_HOURS = 72;
    private final String npmPackages;
    private final Long npmPackagesRefreshHours;
    private Platform platform;
    private CPU cpu;

    @DataBoundConstructor
    public NodeJSInstaller(String id, String npmPackages, long npmPackagesRefreshHours) {
        super(id);
        this.npmPackages = Util.fixEmptyAndTrim((String)npmPackages);
        this.npmPackagesRefreshHours = npmPackagesRefreshHours;
    }

    public DownloadFromUrlInstaller.Installable getInstallable() throws IOException {
        DownloadFromUrlInstaller.Installable installable = super.getInstallable();
        if (installable == null) {
            return null;
        }
        installable = Installables.clone(installable);
        InstallerPathResolver installerPathResolver = InstallerPathResolver.Factory.findResolverFor(installable);
        String relativeDownloadPath = installerPathResolver.resolvePathFor(installable.id, this.platform, this.cpu);
        installable.url = installable.url + relativeDownloadPath;
        return installable;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath expected;
        this.platform = this.getPlatform(node);
        this.cpu = this.getCPU(node);
        DownloadFromUrlInstaller.Installable installable = this.getInstallable();
        if (installable == null || !installable.url.toLowerCase(Locale.ENGLISH).endsWith("msi")) {
            expected = super.performInstallation(tool, node, log);
        } else {
            expected = this.preferredLocation(tool, node);
            if (!this.isUpToDate(expected, installable) && this.installIfNecessaryMSI(expected, new URL(installable.url), log, "Installing " + installable.url + " to " + expected + " on " + node.getDisplayName())) {
                expected.child(".timestamp").delete();
                FilePath base = this.findPullUpDirectory(expected);
                if (base != null && base != expected) {
                    base.moveAllChildrenTo(expected);
                }
                expected.child(".installedFrom").write(installable.url, "UTF-8");
            }
        }
        this.refreshGlobalPackages(node, log, expected);
        return expected;
    }

    private CPU getCPU(Node node) throws IOException, InterruptedException {
        return CPU.of(node);
    }

    private Platform getPlatform(Node node) throws DetectionFailedException {
        return Platform.of(node);
    }

    protected void refreshGlobalPackages(Node node, TaskListener log, FilePath expected) throws IOException, InterruptedException {
        boolean skipNpmPackageInstallation;
        String globalPackages = this.getNpmPackages();
        if (StringUtils.isNotBlank((String)globalPackages) && !(skipNpmPackageInstallation = NodeJSInstaller.areNpmPackagesUpToDate(expected, globalPackages, this.getNpmPackagesRefreshHours()))) {
            expected.child(NPM_PACKAGES_RECORD_FILENAME).delete();
            ArgumentListBuilder npmScriptArgs = new ArgumentListBuilder();
            if (this.platform == Platform.WINDOWS) {
                npmScriptArgs.add("cmd");
                npmScriptArgs.add("/c");
            }
            FilePath binFolder = expected.child(this.platform.binFolder);
            FilePath npmExe = binFolder.child(this.platform.npmFileName);
            npmScriptArgs.add((Object)npmExe);
            npmScriptArgs.add("install");
            npmScriptArgs.add("-g");
            for (String packageName : globalPackages.split("\\s")) {
                npmScriptArgs.add(packageName);
            }
            EnvVars env = new EnvVars();
            env.put("PATH+NODEJS", binFolder.getRemote());
            try {
                this.buildProxyEnvVars(env, log);
            }
            catch (URISyntaxException e) {
                log.error("Wrong proxy URL: " + e.getMessage());
            }
            Launcher launcher = node.createLauncher(log);
            int returnCode = launcher.launch().envs((Map)env).cmds(npmScriptArgs).stdout(log).join();
            if (returnCode == 0) {
                expected.child(NPM_PACKAGES_RECORD_FILENAME).write(globalPackages, "UTF-8");
                expected.child(NPM_PACKAGES_RECORD_FILENAME).act((FilePath.FileCallable)new ChmodRecAPlusX());
            }
        }
    }

    private void buildProxyEnvVars(EnvVars env, TaskListener log) throws IOException, URISyntaxException {
        String userInfo;
        ProxyConfiguration proxycfg = ProxyConfiguration.load();
        if (proxycfg == null) {
            return;
        }
        String string = userInfo = proxycfg.getUserName() != null ? proxycfg.getUserName() : null;
        if (userInfo != null && proxycfg.getEncryptedPassword() != null) {
            userInfo = userInfo + ":" + Secret.decrypt((String)proxycfg.getEncryptedPassword());
        }
        String proxyURL = new URI("http", userInfo, proxycfg.name, proxycfg.port, null, null, null).toString();
        env.put("HTTP_PROXY", proxyURL);
        env.put("HTTPS_PROXY", proxyURL);
        String noProxyHosts = proxycfg.noProxyHost;
        if (noProxyHosts != null) {
            if (noProxyHosts.contains("*")) {
                log.getLogger().println("INFO: npm doesn't support wild card in no_proxy configuration");
            }
            env.put("NO_PROXY", noProxyHosts.replaceAll("(\r?\n)+", ","));
        }
    }

    public static boolean areNpmPackagesUpToDate(FilePath expected, String npmPackages, long npmPackagesRefreshHours) throws IOException, InterruptedException {
        FilePath marker = expected.child(NPM_PACKAGES_RECORD_FILENAME);
        return marker.exists() && marker.readToString().equals(npmPackages) && System.currentTimeMillis() < marker.lastModified() + TimeUnit.HOURS.toMillis(npmPackagesRefreshHours);
    }

    private boolean installIfNecessaryMSI(FilePath expected, URL archive, TaskListener listener, String message) throws IOException, InterruptedException {
        try {
            URLConnection con;
            try {
                con = ProxyConfiguration.open((URL)archive);
                con.connect();
            }
            catch (IOException x) {
                if (expected.exists()) {
                    if (listener != null) {
                        listener.getLogger().println("Skipping installation of " + archive + " to " + expected.getRemote() + ": " + x);
                    }
                    return false;
                }
                throw x;
            }
            long sourceTimestamp = con.getLastModified();
            FilePath timestamp = expected.child(".timestamp");
            if (expected.exists()) {
                if (timestamp.exists() && sourceTimestamp == timestamp.lastModified()) {
                    return false;
                }
                expected.deleteContents();
            } else {
                expected.mkdirs();
            }
            if (listener != null) {
                listener.getLogger().println(message);
            }
            FilePath temp = expected.createTempDir("_temp", "");
            FilePath msi = temp.child("nodejs.msi");
            msi.copyFrom(archive);
            try {
                Launcher launch = temp.createLauncher(listener);
                Launcher.ProcStarter starter = launch.launch().cmds(new File("cmd"), new String[]{"/c", "for %A in (.) do msiexec TARGETDIR=\"%~sA\" /a " + temp.getName() + "\\nodejs.msi /qn /L* " + temp.getName() + "\\log.txt"});
                starter = starter.pwd(expected);
                int exitCode = starter.join();
                if (exitCode != 0) {
                    throw new IOException("msiexec failed. exit code: " + exitCode + " Please see the log file " + temp.child("log.txt").getRemote() + " for more informations.", null);
                }
                if (listener != null) {
                    listener.getLogger().println("msi install complete");
                }
                temp.deleteRecursive();
                FilePath duplicatedMSI = expected.child("nodejs.msi");
                if (duplicatedMSI.exists()) {
                    duplicatedMSI.delete();
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to install " + archive, e);
            }
            timestamp.touch(sourceTimestamp);
            return true;
        }
        catch (IOException e) {
            throw new IOException("Failed to install " + archive + " to " + expected.getRemote(), e);
        }
    }

    public String getNpmPackages() {
        return this.npmPackages;
    }

    public Long getNpmPackagesRefreshHours() {
        return this.npmPackagesRefreshHours;
    }

    @Extension
    public static final class DescriptorImpl
    extends DownloadFromUrlInstaller.DescriptorImpl<NodeJSInstaller> {
        public String getDisplayName() {
            return Messages.NodeJSInstaller_DescriptorImpl_displayName();
        }

        @Nonnull
        public List<? extends DownloadFromUrlInstaller.Installable> getInstallables() throws IOException {
            Collection filteredInstallables = Collections2.filter((Collection)super.getInstallables(), (Predicate)new Predicate<DownloadFromUrlInstaller.Installable>(){

                public boolean apply(DownloadFromUrlInstaller.Installable input) {
                    return !InstallerPathResolver.Factory.isVersionBlacklisted(input.id);
                }
            });
            TreeSet<DownloadFromUrlInstaller.Installable> sortedInstallables = new TreeSet<DownloadFromUrlInstaller.Installable>(new Comparator<DownloadFromUrlInstaller.Installable>(){

                @Override
                public int compare(DownloadFromUrlInstaller.Installable o1, DownloadFromUrlInstaller.Installable o2) {
                    return NodeJSVersion.parseVersion(o1.id).compareTo(NodeJSVersion.parseVersion(o2.id)) * -1;
                }
            });
            sortedInstallables.addAll(filteredInstallables);
            return new ArrayList<DownloadFromUrlInstaller.Installable>(sortedInstallables);
        }

        public String getId() {
            return "hudson.plugins.nodejs.tools.NodeJSInstaller";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == NodeJSInstallation.class;
        }
    }

    static class ChmodRecAPlusX
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        ChmodRecAPlusX() {
        }

        public Void invoke(File d, VirtualChannel channel) throws IOException {
            if (!Functions.isWindows()) {
                this.process(d);
            }
            return null;
        }

        private void process(File f) {
            if (f.isFile()) {
                f.setExecutable(true, false);
            } else {
                File[] kids = f.listFiles();
                if (kids != null) {
                    for (File kid : kids) {
                        this.process(kid);
                    }
                }
            }
        }
    }
}

