/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools.pathresolvers;

import java.text.MessageFormat;
import jenkins.plugins.nodejs.tools.CPU;
import jenkins.plugins.nodejs.tools.InstallerPathResolver;
import jenkins.plugins.nodejs.tools.NodeJSVersion;
import jenkins.plugins.nodejs.tools.NodeJSVersionRange;
import jenkins.plugins.nodejs.tools.Platform;

public class LatestInstallerPathResolver
implements InstallerPathResolver {
    private static final String EXTENSION = "tar.gz";
    private static final String EXTENSION_ZIP = "zip";
    private static final String EXTENSION_MSI = "msi";
    private static final NodeJSVersionRange[] MSI_RANGES = new NodeJSVersionRange[]{new NodeJSVersionRange("[0, 4.5)"), new NodeJSVersionRange("[5, 6.2]")};

    @Override
    public String resolvePathFor(String version, Platform platform, CPU cpu) {
        String arch;
        String extension;
        String path = "";
        String os = null;
        boolean isMSI = false;
        switch (platform) {
            case WINDOWS: {
                isMSI = this.isMSI(version);
                if (!isMSI) {
                    os = "win";
                    extension = EXTENSION_ZIP;
                    break;
                }
                extension = EXTENSION_MSI;
                break;
            }
            case LINUX: {
                os = "linux";
                extension = EXTENSION;
                break;
            }
            case OSX: {
                os = "darwin";
                extension = EXTENSION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unresolvable nodeJS installer for version=" + version + ", platform=" + platform.name());
            }
        }
        switch (cpu) {
            case i386: {
                if (NodeJSVersion.parseVersion(version).compareTo(new NodeJSVersion(4, 0, 0)) >= 0) {
                    throw new IllegalArgumentException("Unresolvable nodeJS installer for version=" + version + ", cpu=" + cpu.name() + ", platform=" + platform.name());
                }
                arch = "x86";
                break;
            }
            case amd64: {
                if (isMSI && NodeJSVersion.parseVersion(version).compareTo(new NodeJSVersion(4, 0, 0)) < 0) {
                    path = "x64/";
                }
                arch = "x64";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unresolvable nodeJS installer for version=" + version + ", cpu=" + cpu.name());
            }
        }
        if (os == null) {
            return MessageFormat.format("{0}node-v{1}-{2}.{3}", path, version, arch, extension);
        }
        return MessageFormat.format("{0}node-v{1}-{2}-{3}.{4}", path, version, os, arch, extension);
    }

    public boolean isMSI(String version) {
        NodeJSVersion currentVersion = new NodeJSVersion(version);
        for (NodeJSVersionRange msiRange : MSI_RANGES) {
            if (!msiRange.includes(currentVersion)) continue;
            return true;
        }
        return false;
    }
}

