/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.NodeJSUtils;
import jenkins.plugins.nodejs.configfiles.NPMConfig;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.plugins.nodejs.tools.Platform;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class NodeJSCommandInterpreter
extends CommandInterpreter {
    private final String nodeJSInstallationName;
    private final String configId;
    private transient String nodeExec;

    @DataBoundConstructor
    public NodeJSCommandInterpreter(String command, String nodeJSInstallationName, String configId) {
        super(command);
        this.nodeJSInstallationName = Util.fixEmpty((String)nodeJSInstallationName);
        this.configId = Util.fixEmpty((String)configId);
    }

    public NodeJSInstallation getNodeJS() {
        return NodeJSUtils.getNodeJS(this.nodeJSInstallationName);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            NodeJSInstallation ni = this.getNodeJS();
            if (ni == null) {
                if (this.nodeJSInstallationName != null) {
                    throw new AbortException(Messages.NodeJSBuilders_noInstallationFound(this.nodeJSInstallationName));
                }
                this.nodeExec = (launcher.isUnix() ? Platform.LINUX : Platform.WINDOWS).nodeFileName;
            } else {
                Node node = build.getBuiltOn();
                if (node == null) {
                    throw new AbortException(Messages.NodeJSBuilders_nodeOffline());
                }
                ni = ni.forNode(node, (TaskListener)listener);
                ni = ni.forEnvironment(env);
                ni.buildEnvVars(env);
                this.nodeExec = ni.getExecutable(launcher);
                if (this.nodeExec == null) {
                    throw new AbortException(Messages.NodeJSBuilders_noExecutableFound(ni.getHome()));
                }
            }
            NodeJSUtils.supplyConfig(this.configId, build, (TaskListener)listener, env);
        }
        catch (AbortException e) {
            listener.fatalError(e.getMessage());
            return false;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(hudson.tasks.Messages.CommandInterpreter_CommandFailed()));
        }
        return super.perform(build, launcher, listener);
    }

    public String[] buildCommandLine(FilePath script) {
        if (this.nodeExec == null) {
            throw new IllegalStateException("Node executable not initialised");
        }
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{this.nodeExec, script.getRemote()});
        return args.toCommandArray();
    }

    protected String getContents() {
        return this.getCommand();
    }

    protected String getFileExtension() {
        return ".js";
    }

    public String getNodeJSInstallationName() {
        return this.nodeJSInstallationName;
    }

    public String getConfigId() {
        return this.configId;
    }

    @Extension
    public static final class NodeJsDescriptor
    extends Descriptor<Builder> {
        public String getDisplayName() {
            return Messages.NodeJSCommandInterpreter_displayName();
        }

        public String getHelpFile() {
            return "/plugin/nodejs/help.html";
        }

        public NodeJSInstallation[] getInstallations() {
            return NodeJSUtils.getInstallations();
        }

        public Collection<Config> getConfigs() {
            return GlobalConfigFiles.get().getConfigs(NPMConfig.NPMConfigProvider.class);
        }

        public FormValidation doCheckConfigId(@CheckForNull @QueryParameter String configId) {
            NPMConfig config = (NPMConfig)GlobalConfigFiles.get().getById(configId);
            if (config != null) {
                try {
                    config.doVerify();
                }
                catch (VerifyConfigProviderException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

