/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.configfiles;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Run;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.plugins.nodejs.configfiles.NPMRegistry;
import jenkins.plugins.nodejs.configfiles.Npmrc;
import org.apache.commons.codec.binary.Base64;

public final class RegistryHelper {
    private final List<NPMRegistry> registries;

    public RegistryHelper(@CheckForNull List<NPMRegistry> registries) {
        this.registries = registries;
    }

    public Map<String, StandardUsernameCredentials> resolveCredentials(Run<?, ?> build) {
        HashMap<String, StandardUsernameCredentials> registry2credential = new HashMap<String, StandardUsernameCredentials>();
        for (NPMRegistry registry : this.registries) {
            StandardUsernameCredentials c;
            String credentialsId = registry.getCredentialsId();
            if (credentialsId == null) continue;
            URL registryURL = RegistryHelper.toURL(registry.getUrl());
            List<Object> domainRequirements = Collections.emptyList();
            if (registryURL != null) {
                domainRequirements = Collections.singletonList(new HostnameRequirement(registryURL.getHost()));
            }
            if ((c = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernameCredentials.class, build, domainRequirements)) == null) continue;
            registry2credential.put(registry.getUrl(), c);
        }
        return registry2credential;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="npm auth_token could not support base64 UTF-8 char encoding")
    public String fillRegistry(String npmrcContent, Map<String, StandardUsernameCredentials> registry2Credentials) {
        Npmrc npmrc = new Npmrc();
        npmrc.from(npmrcContent);
        for (NPMRegistry registry : this.registries) {
            String authValue = null;
            if (registry2Credentials.containsKey(registry.getUrl())) {
                StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)registry2Credentials.get(registry.getUrl());
                authValue = credentials.getUsername() + ':' + Secret.toString((Secret)credentials.getPassword());
                authValue = Base64.encodeBase64String((byte[])authValue.getBytes());
            }
            if (registry.isHasScopes()) {
                for (String scope : registry.getScopesAsList()) {
                    String registryPrefix = this.calculatePrefix(registry.getUrl());
                    npmrc.set(this.compose('@' + scope, "registry"), registry.getUrl());
                    npmrc.set(this.compose(registryPrefix, "always-auth"), authValue != null);
                    if (authValue == null) continue;
                    npmrc.set(this.compose(registryPrefix, "_auth"), authValue);
                }
                continue;
            }
            npmrc.set("registry", registry.getUrl());
            npmrc.set("always-auth", authValue != null);
            if (authValue == null) continue;
            npmrc.set("_auth", authValue);
        }
        return npmrc.toString();
    }

    @Nonnull
    public String calculatePrefix(@Nonnull String registryURL) {
        String trimmedURL = this.trimSlash(registryURL);
        URL url = RegistryHelper.toURL(trimmedURL);
        if (url == null) {
            throw new IllegalArgumentException("Invalid url " + registryURL);
        }
        return "//" + trimmedURL.substring((url.getProtocol() + "://").length()) + '/';
    }

    @Nonnull
    public String compose(@Nonnull String registryPrefix, @Nonnull String setting) {
        return registryPrefix + ":" + setting;
    }

    @Nonnull
    private String trimSlash(@Nonnull String url) {
        if (url != null && url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    @CheckForNull
    private static URL toURL(@Nullable String url) {
        URL result = null;
        String fixedURL = Util.fixEmptyAndTrim((String)url);
        if (fixedURL != null) {
            try {
                return new URL(fixedURL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }
}

