/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeJSVersion
implements Comparable<NodeJSVersion> {
    private Integer major;
    private Integer minor;
    private Integer patch;

    public NodeJSVersion(String version) {
        String[] chunkedVersions = version.split("\\.");
        this.major = Integer.valueOf(chunkedVersions[0]);
        this.minor = Integer.valueOf(chunkedVersions[1]);
        this.patch = Integer.valueOf(chunkedVersions[2]);
    }

    @Override
    public int compareTo(NodeJSVersion v) {
        int cmp = this.major.compareTo(v.major);
        if (cmp == 0 && (cmp = this.minor.compareTo(v.minor)) == 0) {
            return this.patch.compareTo(v.patch);
        }
        return cmp;
    }

    public boolean isLowerThan(NodeJSVersion version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLowerThan(String version) {
        return this.isLowerThan(new NodeJSVersion(version));
    }

    public static int compare(String first, String second) {
        return new NodeJSVersion(first).compareTo(new NodeJSVersion(second));
    }
}

