/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.os.PosixAPI;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.jna.GNUCLibrary;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.plugins.nodejs.tools.InstallerPathResolver;
import jenkins.plugins.nodejs.tools.Messages;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.plugins.nodejs.tools.NodeJSVersion;
import jenkins.plugins.tools.Installables;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.kohsuke.stapler.DataBoundConstructor;

public class NodeJSInstaller
extends DownloadFromUrlInstaller {
    public static final String NPM_PACKAGES_RECORD_FILENAME = ".npmPackages";
    private final String npmPackages;
    private final Long npmPackagesRefreshHours;
    private static final Logger LOGGER = Logger.getLogger(NodeJSInstaller.class.getName());

    @DataBoundConstructor
    public NodeJSInstaller(String id, String npmPackages, long npmPackagesRefreshHours) {
        super(id);
        this.npmPackages = npmPackages;
        this.npmPackagesRefreshHours = npmPackagesRefreshHours;
    }

    public static FilePath binFolderOf(NodeJSInstallation intallation, Node node) {
        FilePath expected = NodeJSInstaller._preferredLocation(intallation, node);
        return expected.child("bin/");
    }

    protected static FilePath _preferredLocation(ToolInstallation tool, Node node) {
        FilePath root;
        if (node == null) {
            throw new IllegalArgumentException("must pass non-null node");
        }
        String home = Util.fixEmptyAndTrim((String)tool.getHome());
        if (home == null) {
            home = NodeJSInstaller.sanitize(tool.getDescriptor().getId()) + File.separatorChar + NodeJSInstaller.sanitize(tool.getName());
        }
        if ((root = node.getRootPath()) == null) {
            throw new IllegalArgumentException("Node " + node.getDisplayName() + " seems to be offline");
        }
        return root.child("tools").child(home);
    }

    private static String sanitize(String s) {
        return s != null ? s.replaceAll("[^A-Za-z0-9_.-]+", "_") : null;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        boolean skipNpmPackageInstallation;
        FilePath expected = this.preferredLocation(tool, node);
        DownloadFromUrlInstaller.Installable inst = this.getInstallable();
        if (inst == null) {
            log.getLogger().println("Invalid tool ID " + this.id);
            return expected;
        }
        inst = Installables.clone(inst);
        InstallerPathResolver installerPathResolver = InstallerPathResolver.Factory.findResolverFor(inst);
        String relativeDownloadPath = this.createDownloadUrl(installerPathResolver, inst, node, log);
        inst.url = inst.url + relativeDownloadPath;
        boolean skipNodeJSInstallation = this.isUpToDate(expected, inst);
        if (!skipNodeJSInstallation && expected.installIfNecessaryFrom(new URL(inst.url), log, "Unpacking " + inst.url + " to " + expected + " on " + node.getDisplayName())) {
            expected.child(".timestamp").delete();
            String archiveIntermediateDirectoryName = installerPathResolver.extractArchiveIntermediateDirectoryName(relativeDownloadPath);
            this.pullUpDirectory(expected, archiveIntermediateDirectoryName);
            expected.child(".installedFrom").write(inst.url, "UTF-8");
            expected.act((FilePath.FileCallable)new ChmodRecAPlusX());
        }
        if (this.npmPackages != null && !"".equals(this.npmPackages) && !(skipNpmPackageInstallation = NodeJSInstaller.areNpmPackagesUpToDate(expected, this.npmPackages, this.npmPackagesRefreshHours))) {
            expected.child(NPM_PACKAGES_RECORD_FILENAME).delete();
            ArgumentListBuilder npmScriptArgs = new ArgumentListBuilder();
            FilePath npmExe = expected.child("bin/npm");
            npmScriptArgs.add((Object)npmExe);
            npmScriptArgs.add("install");
            npmScriptArgs.add("-g");
            for (String packageName : this.npmPackages.split("\\s")) {
                npmScriptArgs.add(packageName);
            }
            Launcher launcher = node.createLauncher(log);
            int returnCode = launcher.launch().envs(new String[]{"PATH+NODEJS=" + expected.child("bin").getRemote()}).cmds(npmScriptArgs).stdout(log).join();
            if (returnCode == 0) {
                expected.child(NPM_PACKAGES_RECORD_FILENAME).write(this.npmPackages, "UTF-8");
                expected.child(NPM_PACKAGES_RECORD_FILENAME).act((FilePath.FileCallable)new ChmodRecAPlusX());
            }
        }
        return expected;
    }

    private static boolean areNpmPackagesUpToDate(FilePath expected, String npmPackages, long npmPackagesRefreshHours) throws IOException, InterruptedException {
        FilePath marker = expected.child(NPM_PACKAGES_RECORD_FILENAME);
        return marker.exists() && marker.readToString().equals(npmPackages) && System.currentTimeMillis() < marker.lastModified() + TimeUnit.HOURS.toMillis(npmPackagesRefreshHours);
    }

    private void pullUpDirectory(FilePath rootNodeHome, String archiveIntermediateDirectoryName) throws IOException, InterruptedException {
        List subfiles = rootNodeHome.list();
        for (FilePath subfile : subfiles) {
            if (archiveIntermediateDirectoryName.equals(subfile.getName())) continue;
            subfile.deleteRecursive();
        }
        FilePath archiveIntermediateDirectoryNameFP = rootNodeHome.child(archiveIntermediateDirectoryName);
        archiveIntermediateDirectoryNameFP.moveAllChildrenTo(rootNodeHome);
    }

    private String createDownloadUrl(InstallerPathResolver installerPathResolver, DownloadFromUrlInstaller.Installable installable, Node node, TaskListener log) throws InterruptedException, IOException {
        try {
            Platform platform = Platform.of(node);
            CPU cpu = CPU.of(node);
            return installerPathResolver.resolvePathFor(installable.id, platform, cpu);
        }
        catch (DetectionFailedException e) {
            throw new IOException(e);
        }
    }

    public String getNpmPackages() {
        return this.npmPackages;
    }

    public Long getNpmPackagesRefreshHours() {
        return this.npmPackagesRefreshHours;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends DownloadFromUrlInstaller.DescriptorImpl<NodeJSInstaller> {
        public String getDisplayName() {
            return Messages.NodeJSInstaller_DescriptorImpl_displayName();
        }

        public List<? extends DownloadFromUrlInstaller.Installable> getInstallables() throws IOException {
            Collection filteredInstallables = Collections2.filter((Collection)super.getInstallables(), (Predicate)new Predicate<DownloadFromUrlInstaller.Installable>(){

                public boolean apply(@Nullable DownloadFromUrlInstaller.Installable input) {
                    return !InstallerPathResolver.Factory.isVersionBlacklisted(input.id);
                }
            });
            TreeSet<DownloadFromUrlInstaller.Installable> sortedInstallables = new TreeSet<DownloadFromUrlInstaller.Installable>(new Comparator<DownloadFromUrlInstaller.Installable>(){

                @Override
                public int compare(DownloadFromUrlInstaller.Installable o1, DownloadFromUrlInstaller.Installable o2) {
                    return NodeJSVersion.compare(o1.id, o2.id) * -1;
                }
            });
            sortedInstallables.addAll(filteredInstallables);
            return new ArrayList<DownloadFromUrlInstaller.Installable>(sortedInstallables);
        }

        public String getId() {
            return "hudson.plugins.nodejs.tools.NodeJSInstaller";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == NodeJSInstallation.class;
        }
    }

    private static final class DetectionFailedException
    extends Exception {
        private DetectionFailedException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CPU {
        i386,
        amd64;


        public Preference accept(String line) {
            switch (this) {
                case amd64: {
                    if (line.contains("SPARC") || line.contains("IA64")) {
                        return Preference.UNACCEPTABLE;
                    }
                    if (line.contains("64")) {
                        return Preference.PRIMARY;
                    }
                    return Preference.SECONDARY;
                }
                case i386: {
                    if (line.contains("64") || line.contains("SPARC") || line.contains("IA64")) {
                        return Preference.UNACCEPTABLE;
                    }
                    return Preference.PRIMARY;
                }
            }
            return Preference.UNACCEPTABLE;
        }

        public static CPU of(Node n) throws IOException, InterruptedException, DetectionFailedException {
            return (CPU)((Object)n.getChannel().call((Callable)new GetCurrentCPU()));
        }

        public static CPU current() throws DetectionFailedException {
            String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
            if (arch.contains("amd64") || arch.contains("86_64")) {
                return amd64;
            }
            if (arch.contains("86")) {
                return i386;
            }
            throw new DetectionFailedException("Unknown CPU architecture: " + arch);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class GetCurrentCPU
        implements Callable<CPU, DetectionFailedException> {
            private static final long serialVersionUID = 1L;

            GetCurrentCPU() {
            }

            public CPU call() throws DetectionFailedException {
                return CPU.current();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        LINUX("node"),
        WINDOWS("node.exe"),
        MAC("node");

        public final String bundleFileName;

        private Platform(String bundleFileName) {
            this.bundleFileName = bundleFileName;
        }

        public boolean is(String line) {
            return line.contains(this.name());
        }

        public static Platform of(Node n) throws IOException, InterruptedException, DetectionFailedException {
            return (Platform)((Object)n.getChannel().call((Callable)new GetCurrentPlatform()));
        }

        public static Platform current() throws DetectionFailedException {
            String arch = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            if (arch.contains("linux")) {
                return LINUX;
            }
            if (arch.contains("windows")) {
                return WINDOWS;
            }
            if (arch.contains("mac")) {
                return MAC;
            }
            throw new DetectionFailedException("Unknown CPU name: " + arch);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class GetCurrentPlatform
        implements Callable<Platform, DetectionFailedException> {
            private static final long serialVersionUID = 1L;

            GetCurrentPlatform() {
            }

            public Platform call() throws DetectionFailedException {
                return Platform.current();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Preference {
        PRIMARY,
        SECONDARY,
        UNACCEPTABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChmodRecAPlusX
    implements FilePath.FileCallable<Void> {
        private static final long serialVersionUID = 1L;

        ChmodRecAPlusX() {
        }

        public Void invoke(File d, VirtualChannel channel) throws IOException {
            if (!Functions.isWindows()) {
                this.process(d);
            }
            return null;
        }

        @IgnoreJRERequirement
        private void process(File f) {
            if (f.isFile()) {
                if (Functions.isMustangOrAbove()) {
                    f.setExecutable(true, false);
                } else {
                    try {
                        GNUCLibrary.LIBC.chmod(f.getAbsolutePath(), 493);
                    }
                    catch (LinkageError e) {
                        PosixAPI.get().chmod(f.getAbsolutePath(), 493);
                    }
                }
            } else {
                File[] kids = f.listFiles();
                if (kids != null) {
                    for (File kid : kids) {
                        this.process(kid);
                    }
                }
            }
        }
    }
}

