/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves.iterators.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.Node;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeIterator<N extends Node>
implements Iterator<N>,
ExtensionPoint {
    @NonNull
    public static NodeIterator<Node> iterator() {
        Jenkins instance = Jenkins.getInstance();
        return instance == null ? new MetaNodeIterator<Node>(Collections.<NodeIterator<Node>>emptyIterator(), Node.class) : new MetaNodeIterator<Node>(instance.getExtensionList(NodeIterator.class).iterator(), Node.class);
    }

    @NonNull
    public static Iterable<Node> nodes() {
        return NodeIterable.ResourceHolder.INSTANCE;
    }

    @NonNull
    public static <N extends Node> NodeIterator<N> iterator(@NonNull Class<N> nodeClass) {
        nodeClass.getClass();
        Jenkins instance = Jenkins.getInstance();
        return instance == null ? new MetaNodeIterator<N>(Collections.<NodeIterator<Node>>emptyIterator(), nodeClass) : new MetaNodeIterator<N>(instance.getExtensionList(NodeIterator.class).iterator(), nodeClass);
    }

    @NonNull
    public static <N extends Node> Iterable<N> nodes(@NonNull Class<N> nodeClass) {
        nodeClass.getClass();
        return nodeClass.equals(Node.class) ? NodeIterator.nodes() : new NodeIterable(nodeClass);
    }

    public static boolean isComplete() {
        return NodeIterator.isComplete(Node.class);
    }

    public static <N extends Node> boolean isComplete(@NonNull Class<N> nodeClass) {
        nodeClass.getClass();
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return false;
        }
        for (NodeIterator iterator : instance.getExtensionList(NodeIterator.class)) {
            if (iterator.hasCompleteLiveSet(nodeClass)) continue;
            return false;
        }
        return true;
    }

    protected <N extends Node> boolean hasCompleteLiveSet(@NonNull Class<N> nodeClass) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeIterable<N extends Node>
    implements Iterable<N> {
        @NonNull
        private final Class<N> nodeClass;

        private NodeIterable(@NonNull Class<N> nodeClass) {
            this.nodeClass = nodeClass;
        }

        @Override
        @NonNull
        public Iterator<N> iterator() {
            return NodeIterator.iterator(this.nodeClass);
        }

        private static final class ResourceHolder {
            private static final NodeIterable<Node> INSTANCE = new NodeIterable(Node.class);

            private ResourceHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaNodeIterator<N extends Node>
    extends NodeIterator<N> {
        @NonNull
        private final Class<N> nodeClass;
        @NonNull
        private final Iterator<NodeIterator<? extends Node>> metaIterator;
        @CheckForNull
        private Iterator<? extends Node> delegate;
        @CheckForNull
        private N next;

        MetaNodeIterator(@NonNull Iterator<NodeIterator<? extends Node>> metaIterator, @NonNull Class<N> nodeClass) {
            List nodes;
            metaIterator.getClass();
            nodeClass.getClass();
            Jenkins instance = Jenkins.getInstance();
            this.delegate = instance == null ? Collections.emptyIterator() : ((nodes = instance.getNodes()) == null ? Collections.emptyIterator() : nodes.iterator());
            this.metaIterator = metaIterator;
            this.nodeClass = nodeClass;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.delegate != null && this.delegate.hasNext() || this.metaIterator.hasNext()) {
                while (this.delegate != null && this.delegate.hasNext()) {
                    Node _next = this.delegate.next();
                    if (!this.nodeClass.isInstance(_next)) continue;
                    this.next = (Node)this.nodeClass.cast(_next);
                    return true;
                }
                while (this.metaIterator.hasNext() && (this.delegate == null || !this.delegate.hasNext())) {
                    this.delegate = this.metaIterator.next();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public N next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                N n = this.next;
                return n;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

