/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import hudson.model.AbstractProject;
import hudson.plugins.nested_view.search.ExtendedSearch;
import hudson.plugins.nested_view.search.ProjectWrapper;
import hudson.plugins.nested_view.search.Query;
import hudson.search.SearchIndex;
import hudson.search.SearchItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;

public class NestedViewsSearchResult
implements SearchItem,
ExtendedSearch {
    private final String searchName;
    private final String searchUrl;
    private final ProjectWrapper project;

    public boolean isStillValid() {
        if (this.project != null) {
            return this.project.isStillValid();
        }
        return true;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public String getSearchUrl() {
        return this.searchUrl;
    }

    public SearchIndex getSearchIndex() {
        return null;
    }

    public NestedViewsSearchResult(String searchName, String searchUrl, Optional<AbstractProject> project, Query query, Collection<String> matched) {
        this.searchName = searchName;
        this.searchUrl = searchUrl;
        this.project = query != null ? new ProjectWrapper(project, query.isMultiline(), query.isProjectInfo(), query.getStats(), query.getLast(), query.getBuilds(), query, matched) : new ProjectWrapper(Optional.empty(), false, false, -1, -1, -1, null, null);
    }

    public String toString() {
        return this.searchName;
    }

    public String toPlainOldHref() {
        return "<a href=\"" + this.searchUrl + "\">" + this.searchName + "</a>";
    }

    @Override
    public ProjectWrapper getProject() {
        return this.project;
    }

    public void createDetails() {
        this.project.createDetails();
    }

    private long getDate() {
        return this.project.getDateTime();
    }

    public static class DateComparator
    implements Comparator<NestedViewsSearchResult>,
    Serializable {
        @Override
        public int compare(NestedViewsSearchResult a, NestedViewsSearchResult b) {
            if (a.getDate() == b.getDate()) {
                return 0;
            }
            if (a.getDate() > b.getDate()) {
                return -1;
            }
            return 1;
        }
    }

    public static class NameComparator
    implements Comparator<NestedViewsSearchResult>,
    Serializable {
        @Override
        public int compare(NestedViewsSearchResult a, NestedViewsSearchResult b) {
            return a.toString().compareTo(b.toString());
        }
    }

    public static class LenghtComparator
    implements Comparator<NestedViewsSearchResult>,
    Serializable {
        @Override
        public int compare(NestedViewsSearchResult a, NestedViewsSearchResult b) {
            return a.toString().length() - b.toString().length();
        }
    }
}

