/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.nested_view.NestedViewsSearch;
import hudson.plugins.nested_view.search.BuildDetails;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;

public class HistoryItem {
    private static final int MAX_HISTORY = 500;
    private static final File historyCache = new File(Jenkins.get().root, ".nested-view-serch.cache");
    private static final List<HistoryItem> history = HistoryItem.load();
    private final String query;
    private final int size;
    private final Date date;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="date is not cared")
    public HistoryItem(String query, int size, Date date) {
        this.query = query;
        this.size = size;
        this.date = date;
    }

    public static void save() {
        try {
            HistoryItem.saveImp();
        }
        catch (Exception ex) {
            NestedViewsSearch.LOGGER.log(Level.SEVERE, "saving nested view search history failed", ex);
        }
    }

    public static void saveImp() throws IOException {
        Files.write(historyCache.toPath(), (Iterable<? extends CharSequence>)history.stream().map(a -> a.toSave()).collect(Collectors.toList()), new OpenOption[0]);
    }

    public static List<HistoryItem> load() {
        List<Object> l = new ArrayList(0);
        if (historyCache.exists()) {
            try {
                l = Files.readAllLines(historyCache.toPath());
            }
            catch (Exception ex) {
                NestedViewsSearch.LOGGER.log(Level.SEVERE, "loading nested view search history failed", ex);
            }
        }
        ArrayList<HistoryItem> r = new ArrayList<HistoryItem>(500);
        for (String string : l) {
            try {
                r.add(new HistoryItem(string));
            }
            catch (Exception ex) {
                NestedViewsSearch.LOGGER.log(Level.SEVERE, "reading nested view search history " + string + " failed", ex);
            }
        }
        return Collections.synchronizedList(r);
    }

    public static List<HistoryItem> get() {
        return Collections.unmodifiableList(history);
    }

    public static void add(HistoryItem his) {
        history.removeAll(Collections.singleton(his));
        history.add(0, his);
        while (history.size() > 500) {
            history.remove(history.size() - 1);
        }
        HistoryItem.save();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryItem that = (HistoryItem)o;
        return this.query.equals(that.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public String getQuery() {
        return this.query;
    }

    public String getUrl() {
        return BuildDetails.getJenkinsUrl() + "/search/?q=" + this.getQuery();
    }

    public int getSize() {
        return this.size;
    }

    public String getDate() {
        return new SimpleDateFormat("HH:mm:ss dd/MM").format(this.date);
    }

    public String toSave() {
        return this.size + " " + this.date.getTime() + " " + this.query;
    }

    public HistoryItem(String saved) {
        String[] sd = saved.split(" ");
        this.size = Integer.parseInt(sd[0]);
        this.date = new Date(Long.parseLong(sd[1]));
        this.query = saved.replace(this.size + " " + this.date.getTime() + " ", "");
    }
}

