// CHECKSTYLE:OFF

package hudson.plugins.nested_view;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ViewHealth}: {@code Average health of {0} jobs}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Average health of {0} jobs}
     */
    public static String ViewHealth(Object arg0) {
        return holder.format("ViewHealth", arg0);
    }

    /**
     * Key {@code ViewHealth}: {@code Average health of {0} jobs}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Average health of {0} jobs}
     */
    public static Localizable _ViewHealth(Object arg0) {
        return new Localizable(holder, "ViewHealth", arg0);
    }

    /**
     * Key {@code DisplayName}: {@code Nested View}.
     * 
     * @return
     *     {@code Nested View}
     */
    public static String DisplayName() {
        return holder.format("DisplayName");
    }

    /**
     * Key {@code DisplayName}: {@code Nested View}.
     * 
     * @return
     *     {@code Nested View}
     */
    public static Localizable _DisplayName() {
        return new Localizable(holder, "DisplayName");
    }

    /**
     * Key {@code NoJobs}: {@code Subview contains no jobs}.
     * 
     * @return
     *     {@code Subview contains no jobs}
     */
    public static String NoJobs() {
        return holder.format("NoJobs");
    }

    /**
     * Key {@code NoJobs}: {@code Subview contains no jobs}.
     * 
     * @return
     *     {@code Subview contains no jobs}
     */
    public static Localizable _NoJobs() {
        return new Localizable(holder, "NoJobs");
    }

}
