/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Utils {
    private static DocumentBuilderFactory _factory;
    private static Transformer _xformer;
    private static DocumentBuilder _builder;
    public static List<Document> parsedDocuments;
    public static String lastXMLAsString;

    private static DocumentBuilder builder() throws Exception {
        if (_builder == null) {
            _factory = DocumentBuilderFactory.newInstance();
            _factory.setNamespaceAware(true);
            _xformer = TransformerFactory.newInstance().newTransformer();
            _builder = _factory.newDocumentBuilder();
        }
        return _builder;
    }

    private static Transformer xformer() throws Exception {
        Utils.builder();
        return _xformer;
    }

    public static void cacheDocument(Document doc) {
        parsedDocuments.add(doc);
        while (parsedDocuments.size() > 20) {
            parsedDocuments.remove(0);
        }
    }

    public static Document getEntityContentAsDocument(HttpEntity entity) throws Exception {
        InputStream in = entity.getContent();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int n = 0;
        byte[] ab = new byte[4096];
        while ((n = in.read(ab)) != -1) {
            out.write(ab, 0, n);
        }
        lastXMLAsString = out.toString("UTF-8");
        return Utils.bytes2xml(out.toByteArray());
    }

    public static Document string2xml(String s) throws Exception {
        return Utils.bytes2xml(s.getBytes("UTF-8"));
    }

    public static Document bytes2xml(byte[] ab) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(ab);
        Document doc = Utils.builder().parse(in);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document file2xml(String filename) throws Exception {
        FileInputStream in = null;
        try {
            Document doc;
            in = new FileInputStream(filename);
            Document document = doc = Utils.builder().parse(in);
            return document;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {}
        }
    }

    public static void xml2file(Document doc, File file) throws Exception {
        FileWriter sw = new FileWriter(file);
        PrintWriter pw = new PrintWriter(sw);
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(pw);
        Utils.xformer().transform(source, result);
        pw.close();
    }

    public static String getTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String uniqueTagValue(String tagname, Document doc, boolean bMandatory) throws Exception {
        String result = null;
        NodeList list = doc.getElementsByTagName(tagname);
        if (list != null && list.getLength() > 0) {
            result = Utils.nodeValue(list.item(0));
        } else if (bMandatory) {
            throw new Exception("Tag " + tagname + " not found in XML document");
        }
        return result;
    }

    public static Node getChildNode(Node parent, String child_tagname) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!child.getNodeName().equalsIgnoreCase(child_tagname)) continue;
            return child;
        }
        return null;
    }

    public static String getUniqueChildNodeValue(Node parent, String child_tagname) throws Exception {
        Node n = Utils.getChildNode(parent, child_tagname);
        return Utils.nodeValue(n);
    }

    public static Document parseResponse(HttpEntity entity) throws Exception {
        Document doc = Utils.getEntityContentAsDocument(entity);
        Utils.cacheDocument(doc);
        if (doc.getDocumentElement().getNodeName().equals("errors")) {
            throw new Exception(Utils.parseErrorResponseImpl(doc));
        }
        return doc;
    }

    public static String parseErrorResponse(HttpEntity entity) throws Exception {
        Document doc = Utils.getEntityContentAsDocument(entity);
        Utils.cacheDocument(doc);
        return Utils.parseErrorResponseImpl(doc);
    }

    private static String parseErrorResponseImpl(Document doc) throws Exception {
        NodeList list = doc.getElementsByTagName("description");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.getLength(); ++i) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(Utils.nodeValue(list.item(i)));
        }
        return sb.toString();
    }

    public ByteArrayInputStream getResponseContent(HttpEntity entity) throws Exception {
        InputStream in = entity.getContent();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] ab = new byte[4096];
        int read = 0;
        while ((read = in.read(ab)) > 0) {
            bout.write(ab, 0, read);
        }
        ab = bout.toByteArray();
        return new ByteArrayInputStream(ab);
    }

    public static String xml2string(Document doc) throws Exception {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(pw);
        Utils.xformer().transform(source, result);
        return sw.toString();
    }

    public static String nodeValue(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        String value = null;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
            value = child.getNodeValue();
            if (value == null || value.trim().length() != 0) break;
            value = null;
            break;
        }
        return value;
    }

    public static void setCDATAValue(Node node, String data) {
        CDATASection node_cdata = null;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 4) continue;
            node_cdata = (CDATASection)list.item(i);
            break;
        }
        if (data != null && data.trim().length() > 0) {
            if (node_cdata == null) {
                node_cdata = node.getOwnerDocument().createCDATASection(data);
                node.appendChild(node_cdata);
            } else {
                node_cdata.setData(data);
            }
        } else if (node_cdata != null) {
            node.removeChild(node_cdata);
        }
    }

    public static void setNodeTextValue(Node node, String text) {
        CharacterData node_text = null;
        if (text == null) {
            text = "";
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 3) continue;
            node_text = (Text)list.item(i);
            break;
        }
        if (text.trim().length() > 0) {
            if (node_text == null) {
                node_text = node.getOwnerDocument().createTextNode(text);
                node.appendChild(node_text);
            } else {
                node_text.setData(text);
            }
        } else if (node_text != null) {
            node.removeChild(node_text);
        }
    }

    public static void setChildNodeCDATAValue(Node parent, String child_name, String data) {
        Node child = Utils.getChildNode(parent, child_name);
        if (child == null) {
            child = Utils.createChildElement(parent, child_name);
        }
        Utils.setCDATAValue(child, data);
    }

    public static void setChildNodeTextValue(Node parent, String child_name, String data) {
        Node child = Utils.createChildElementIfNotExists(parent, child_name);
        if (child == null) {
            child = Utils.createChildElement(parent, child_name);
        }
        Utils.setNodeTextValue(child, data);
    }

    public static Node createChildElementIfNotExists(Node parent, String child_name) {
        Node child = Utils.getChildNode(parent, child_name);
        if (child == null) {
            child = Utils.createChildElement(parent, child_name);
        }
        return child;
    }

    public static Element createChildElement(Node parent, String tag) {
        Element child = parent.getOwnerDocument().createElement(tag);
        parent.appendChild(child);
        return child;
    }

    public static Element createChildElement(Node parent, String tag, String text) {
        Element child = parent.getOwnerDocument().createElement(tag);
        parent.appendChild(child);
        if (text != null) {
            Utils.setNodeTextValue(child, text);
        }
        return child;
    }

    public static void printSystemProperties(PrintStream out) {
        int i;
        Vector<String> unsorted = new Vector<String>();
        Properties p = System.getProperties();
        Enumeration<Object> enm = p.keys();
        while (enm.hasMoreElements()) {
            String key = enm.nextElement().toString();
            String val = p.getProperty(key);
            unsorted.addElement(key + " = " + val);
        }
        Vector<String> sorted = new Vector<String>();
        for (i = 0; i < unsorted.size(); ++i) {
            boolean bAdded = false;
            String s1 = unsorted.elementAt(i).toString();
            for (int j = 0; j < sorted.size(); ++j) {
                String s2 = sorted.elementAt(j).toString();
                if (s2.compareTo(s1) < 0) continue;
                sorted.insertElementAt(s1, j);
                bAdded = true;
                break;
            }
            if (bAdded) continue;
            sorted.addElement(s1);
        }
        for (i = 0; i < sorted.size(); ++i) {
            out.println(sorted.elementAt(i).toString());
        }
    }

    static {
        parsedDocuments = new ArrayList<Document>();
    }
}

