/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpaceData {
    public String id;
    public String name;
    public String ftp_path;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFtppath() {
        return this.ftp_path;
    }

    public static SpaceData parseSpaceData(Document doc) throws Exception {
        NodeList list = null;
        list = doc.getElementsByTagName("space");
        if (list == null || list.getLength() == 0) {
            throw new Exception("Invalid space data XML");
        }
        Node nodeSpace = list.item(0);
        list = nodeSpace.getChildNodes();
        SpaceData spd = new SpaceData();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeName().equals("id")) {
                spd.id = Utils.nodeValue(n);
                continue;
            }
            if (n.getNodeName().equals("name")) {
                spd.name = Utils.nodeValue(n);
                continue;
            }
            if (!n.getNodeName().equals("ftp_path")) continue;
            spd.ftp_path = Utils.nodeValue(n);
        }
        if (spd.id == null || spd.ftp_path == null) {
            throw new Exception("Invalid Space data");
        }
        return spd;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t---BEGIN SPACE#").append(this.id).append("---\n").append("\t\tName: ").append(this.name).append("\n").append("\t\tPath: ").append(this.ftp_path).append("\n");
        sb.append("\t-----END SPACE#").append(this.id).append("---\n\n");
        return sb.toString();
    }
}

