/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.HttpCommunicator;
import com.deepshiftlabs.nerrvana.NerrvanaPluginSettings;
import com.deepshiftlabs.nerrvana.Platform;
import com.deepshiftlabs.nerrvana.Utils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class SignatureTest {
    public static void main(String[] args) throws Exception {
        String line;
        if (args.length == 0) {
            System.out.println("Usage: java -cp nerrvana-plugin.jar com.deepshiftlabs.nerrvana.SignatureTest <path to plugin config> [optional - config file charset]");
            System.exit(0);
        }
        String filename = args[0];
        String charset = "ASCII";
        if (args.length > 1) {
            charset = args[1];
        }
        FileInputStream in = new FileInputStream(args[0]);
        StringBuilder sb = new StringBuilder();
        InputStreamReader inR = new InputStreamReader((InputStream)in, charset);
        BufferedReader buf = new BufferedReader(inR);
        while ((line = buf.readLine()) != null) {
            sb.append(line);
        }
        String settingsXmlString = sb.toString();
        NerrvanaPluginSettings settings = NerrvanaPluginSettings.parse(Utils.string2xml(settingsXmlString));
        System.out.println("API key:\t" + settings.apikey);
        System.out.println("Secret key: " + settings.secretkey);
        HttpCommunicator comm = new HttpCommunicator(settings);
        sb = new StringBuilder();
        Iterator<Platform> it = settings.platforms.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(it.next().code);
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("space_id", settings.space_id));
        params.add((NameValuePair)new BasicNameValuePair("name", settings.test_run_name));
        params.add((NameValuePair)new BasicNameValuePair("description", settings.test_run_descr));
        params.add((NameValuePair)new BasicNameValuePair("platforms", sb.toString()));
        params.add((NameValuePair)new BasicNameValuePair("executable_file", settings.executable_file));
        params.add((NameValuePair)new BasicNameValuePair("validation", "0"));
        params.add((NameValuePair)new BasicNameValuePair("nodes_count", "" + settings.nodes_count));
        params.add((NameValuePair)new BasicNameValuePair("apikey", settings.apikey));
        System.out.println("---BEGIN PARAMETERS FOR SIGNATURE---");
        for (NameValuePair nvp : params) {
            System.out.println(nvp.getName() + " => " + nvp.getValue());
        }
        System.out.println("-----END PARAMETERS FOR SIGNATURE---\n");
        String signature1 = comm.calculateSignature(params);
        String signature2 = comm.calculateSignature(params, charset);
        System.out.println("Signature for test run(old version): " + signature1);
        System.out.println("Signature for test run(" + charset + " version): " + signature2);
    }
}

