/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.UserMessage;
import com.deepshiftlabs.nerrvana.UserMessageLevel;
import com.deepshiftlabs.nerrvana.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Platform {
    public String id;
    public String code;
    public String name;
    public String status;
    public String browse_url;
    public SortedMap<UserMessageLevel, List<UserMessage>> sortedMessages;
    public List<UserMessage> messages;

    public Platform() {
    }

    public Platform(String id, String code, String name, String status, String browse_url) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.status = status;
        this.browse_url = browse_url;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        if (this.status != null && this.status.equalsIgnoreCase("ok")) {
            for (UserMessage m : this.messages) {
                if (m.level.value() <= UserMessageLevel.WARN.value()) continue;
                return "<span class=\"failure\">TESTS FAILURE</span>";
            }
            return "<span class=\"failure\">SUCCESS</span>";
        }
        return "<span class=\"success\">NERRVANA FAILURE</span>";
    }

    public String getBrowseurl() {
        return this.browse_url != null && this.browse_url.length() > 0 ? this.browse_url : "Not available";
    }

    public String getBrowseurlMarkup() {
        StringBuilder sb = new StringBuilder();
        if (this.browse_url != null && this.browse_url.length() > 0) {
            sb.append("var w = window.open('").append(this.browse_url).append("','_blank','');w.focus();");
        } else {
            sb.append("return false;");
        }
        return sb.toString();
    }

    public String getBrowsetitle() {
        return this.browse_url == null || this.browse_url.indexOf("://") < 0 ? "Not available" : "-&gt; at Nerrvana &lt;-";
    }

    public SortedMap<UserMessageLevel, List<UserMessage>> getSortedMessages() {
        return this.sortedMessages;
    }

    public List<UserMessage> getMessages() {
        return this.messages;
    }

    public int getMessageCount() {
        return this.messages == null ? 0 : this.messages.size();
    }

    public String getMessagesLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.sortedMessages != null) {
            for (UserMessageLevel level : UserMessageLevel.values()) {
                List list = (List)this.sortedMessages.get((Object)level);
                if (list == null || list.size() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(level.name().toUpperCase()).append("(").append(list.size()).append(")");
            }
        }
        return sb.toString();
    }

    public static ArrayList<Platform> getPlatformList(Node parent) throws Exception {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!n.getNodeName().equals("platform")) continue;
            platforms.add(Platform.parsePlatform(n));
        }
        return platforms;
    }

    private static Platform parsePlatform(Node parent) throws Exception {
        NodeList list = parent.getChildNodes();
        Platform platform = new Platform();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            String name = n.getNodeName();
            String value = Utils.nodeValue(n);
            if (name.equals("id")) {
                platform.id = value;
                continue;
            }
            if (name.equals("code")) {
                platform.code = value;
                continue;
            }
            if (name.equals("name")) {
                platform.name = value;
                continue;
            }
            if (name.equals("status")) {
                platform.status = value;
                continue;
            }
            if (name.equals("browse_url")) {
                platform.browse_url = value;
                continue;
            }
            if (!name.equals("messages")) continue;
            platform.sortedMessages = UserMessage.getPlatformUserMessages(parent);
            platform.messages = Platform.sortedToPlainlist(platform.sortedMessages);
        }
        return platform;
    }

    private static List<UserMessage> sortedToPlainlist(SortedMap<UserMessageLevel, List<UserMessage>> sortedMessages) {
        ArrayList<UserMessage> plainlist = new ArrayList<UserMessage>();
        if (sortedMessages != null) {
            for (UserMessageLevel level : UserMessageLevel.values()) {
                List list = (List)sortedMessages.get((Object)level);
                if (list == null || list.size() <= 0) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    plainlist.add((UserMessage)iterator.next());
                }
            }
        }
        return plainlist;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sid = this.id == null ? "[N/A]" : this.id.toString();
        sb.append("\t---BEGIN PLATFORM#").append(sid).append("---\n").append("\t\tContext: ").append(this.name).append("\n").append("\t\tStatus: ").append(this.status).append("\n");
        if (this.browse_url != null && this.browse_url.length() > 0) {
            sb.append("\t\tBrowse: ").append(this.browse_url).append("\n");
        }
        sb.append("\t-----END PLATFORM#").append(sid).append("---\n\n");
        return sb.toString();
    }
}

