/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.Utils;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    public static final int LL_NORMAL = 0;
    public static final int LL_TRACE = 1;
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private PrintStream logger;
    private int iLogLevel = 0;
    private static Logger singleInstance;

    public static void init(PrintStream logger, String loglevel) {
        singleInstance = new Logger(logger, loglevel);
    }

    private Logger(PrintStream logger, String loglevel) {
        this.iLogLevel = loglevel != null && loglevel.equals("trace") ? 1 : 0;
        this.logger = logger;
    }

    public int getLevel() {
        return this.iLogLevel;
    }

    public void setLevel(int iLogLevel) {
        this.iLogLevel = iLogLevel;
    }

    public static void info(String s) {
        if (singleInstance != null) {
            singleInstance.log(s, 0);
        }
    }

    public static void trace(String s) {
        if (singleInstance != null) {
            singleInstance.log(s, 1);
        }
    }

    public static void infoln(String s) {
        if (singleInstance != null) {
            singleInstance.log(s + "\n", 0);
        }
    }

    public static void traceln(String s) {
        if (singleInstance != null) {
            singleInstance.log(s + "\n", 1);
        }
    }

    public static void exception(Throwable e) {
        if (singleInstance != null) {
            String cls = e.getClass().getName();
            if (cls.indexOf("xml") >= 0 && Utils.lastXMLAsString != null && Utils.lastXMLAsString.length() > 0) {
                Logger.infoln("---BEGIN LAST PARSED XML DOCUMENT");
                Logger.infoln(Utils.lastXMLAsString);
                Logger.infoln("-----END LAST PARSED XML DOCUMENT");
            }
            singleInstance.log(e);
        }
    }

    public static void tori(String trace, String normal) {
        if (singleInstance != null) {
            if (singleInstance.getLevel() == 1) {
                Logger.trace(trace);
            } else if (singleInstance.getLevel() == 0) {
                Logger.infoln(normal);
            }
        }
    }

    private void log(String s, int level) {
        if (this.logger != null && level <= this.iLogLevel) {
            this.logger.print(df.format(new Date()) + " " + s);
        }
    }

    private void log(Throwable e) {
        if (this.logger != null) {
            this.logger.println(Utils.getTraceAsString(e));
        }
    }
}

