/*
 * Decompiled with CFR 0.152.
 */
package com.deepshiftlabs.nerrvana;

import com.deepshiftlabs.nerrvana.Logger;
import com.deepshiftlabs.nerrvana.NerrvanaExecution;
import com.deepshiftlabs.nerrvana.NerrvanaPluginSettings;
import com.deepshiftlabs.nerrvana.Platform;
import com.deepshiftlabs.nerrvana.ResponseException;
import com.deepshiftlabs.nerrvana.Testrun;
import com.deepshiftlabs.nerrvana.Utils;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.iharder.Base64;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCommunicator {
    private NerrvanaPluginSettings settings;
    public static final String[] PARAMS = new String[]{"http.useragent", "http.protocol.version", "http.protocol.unambiguous-statusline", "http.protocol.single-cookie-header", "http.protocol.strict-transfer-encoding", "http.protocol.reject-head-body", "http.protocol.head-body-timeout", "http.protocol.expect-continue", "http.protocol.credential-charset", "http.protocol.element-charset", "http.protocol.content-charset", "http.protocol.cookie-policy", "http.protocol.warn-extra-input", "http.protocol.status-line-garbage-limit", "http.socket.timeout", "http.method.retry-handler", "http.dateparser.patterns", "http.method.response.buffer.warnlimit", "http.method.multipart.boundary", "http.socket.timeout", "http.tcp.nodelay", "http.socket.sendbuffer", "http.socket.receivebuffer", "http.socket.linger", "http.connection.timeout", "http.connection.stalecheck", "http.connection-manager.max-per-host", "http.connection-manager.max-total", "http.default-headers", "http.connection-manager.timeout", "http.connection-manager.class", "http.authentication.preemptive", "http.protocol.reject-relative-redirect", "http.protocol.max-redirects", "http.protocol.allow-circular-redirects"};

    public HttpCommunicator(NerrvanaPluginSettings settings) {
        this.settings = settings;
    }

    private HttpClient createClient() throws NoSuchAlgorithmException, KeyManagementException {
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setBooleanParameter("http.nodelay", false);
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx);
        ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = client.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", (SocketFactory)ssf, 443));
        return new DefaultHttpClient(ccm, client.getParams());
    }

    public String calculateSignature(List<NameValuePair> params) throws Exception {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (NameValuePair nvp : params) {
            String k = nvp.getName() == null ? "" : nvp.getName().trim();
            String v = nvp.getValue() == null ? "" : nvp.getValue().trim();
            map.put(k, v);
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String value = (String)entry.getValue();
            System.out.println("$params['" + (String)entry.getKey() + "'] = '" + value + "';");
            Logger.traceln("$params['" + (String)entry.getKey() + "'] = '" + value + "';");
            sb.append((String)entry.getKey()).append(value);
        }
        String s = sb.toString();
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret = new SecretKeySpec(this.settings.secretkey.trim().getBytes(), "HmacSHA256");
        byte[] secretEncoded = secret.getEncoded();
        String s64 = Base64.encodeBytes(secretEncoded);
        System.out.println("Secret[base64]: " + s64);
        Logger.traceln("Secret[base64]: " + s64);
        mac.init(secret);
        byte[] digest = mac.doFinal(s.getBytes());
        String d64 = Base64.encodeBytes(digest);
        System.out.println("Signature[base64]: " + d64);
        Logger.traceln("Signature[base64]: " + d64);
        digest = MessageDigest.getInstance("MD5").digest(d64.getBytes());
        sb = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public String calculateSignature(List<NameValuePair> params, String charset) throws Exception {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (NameValuePair nvp : params) {
            String k = nvp.getName() == null ? "" : nvp.getName().trim();
            String v = nvp.getValue() == null ? "" : nvp.getValue().trim();
            map.put(k, v);
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String value = (String)entry.getValue();
            System.out.println("$params['" + (String)entry.getKey() + "'] = '" + value + "';");
            Logger.traceln("$params['" + (String)entry.getKey() + "'] = '" + value + "';");
            sb.append((String)entry.getKey()).append(value);
        }
        String s = sb.toString();
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret = new SecretKeySpec(this.settings.secretkey.trim().getBytes(charset), "HmacSHA256");
        byte[] secretEncoded = secret.getEncoded();
        String s64 = Base64.encodeBytes(secretEncoded);
        System.out.println("Secret[base64]: " + s64);
        Logger.traceln("Secret[base64]: " + s64);
        mac.init(secret);
        byte[] digest = mac.doFinal(s.getBytes(charset));
        String d64 = Base64.encodeBytes(digest);
        System.out.println("Signature[base64]: " + d64);
        Logger.traceln("Signature[base64]: " + d64);
        digest = MessageDigest.getInstance("MD5").digest(d64.getBytes(charset));
        sb = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public void traceResponseHeaders(HttpResponse response) throws Exception {
        Logger.traceln("---BEGIN RESPONSE HEADERS---");
        HeaderIterator it = response.headerIterator();
        while (it.hasNext()) {
            Header h = it.nextHeader();
            Logger.traceln("\t" + h.getName() + " => " + h.getValue());
        }
        Logger.traceln("---END RESPONSE HEADERS---");
    }

    public void traceParams(HttpParams params) throws Exception {
        Logger.traceln("---BEGIN PARAMS---");
        for (int i = 0; i < PARAMS.length; ++i) {
            String key = PARAMS[i];
            Object o = params.getParameter(PARAMS[i]);
            if (o == null) continue;
            Logger.traceln("\t" + key + " => " + o.toString());
        }
        Logger.traceln("-----END PARAMS---");
    }

    private HttpEntity request(String resource, List<NameValuePair> params, boolean bGet) throws Exception {
        HttpClient client = null;
        HttpResponse response = null;
        BufferedHttpEntity entity = null;
        String fullUrl = null;
        try {
            params.add((NameValuePair)new BasicNameValuePair("apikey", this.settings.apikey));
            String signature = this.calculateSignature(params);
            Logger.traceln("signature => " + signature);
            params.add((NameValuePair)new BasicNameValuePair("signature", signature));
            client = this.createClient();
            if (bGet) {
                fullUrl = this.makeUrl(this.settings.httpurl, resource) + "?" + URLEncodedUtils.format(params, (String)"UTF-8");
                Logger.traceln("GET " + fullUrl);
                HttpGet get = new HttpGet(fullUrl);
                response = client.execute((HttpUriRequest)get);
            } else {
                fullUrl = this.makeUrl(this.settings.httpurl, resource);
                Logger.traceln("POST " + fullUrl);
                HttpPost post = new HttpPost(fullUrl);
                post.getParams().setBooleanParameter("http.protocol.warn-extra-input", true);
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                response = client.execute((HttpUriRequest)post);
            }
            StatusLine sline = response.getStatusLine();
            int statusCode = sline.getStatusCode();
            entity = new BufferedHttpEntity(response.getEntity());
            if (statusCode == 200) {
                BufferedHttpEntity bufferedHttpEntity = entity;
                return bufferedHttpEntity;
            }
            StringBuilder sb = new StringBuilder("Error occured when communicating with Nerrvana server\n---BEGIN ERROR--\n");
            sb.append(sline.toString()).append(": ").append(Utils.parseErrorResponse((HttpEntity)entity)).append("\n-----END ERROR--\n");
            throw new ResponseException(sb.toString(), statusCode);
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
        }
    }

    public HttpEntity get(String resource, List<NameValuePair> params) throws Exception {
        return this.request(resource, params, true);
    }

    public HttpEntity post(String resource, List<NameValuePair> params) throws Exception {
        return this.request(resource, params, false);
    }

    private Exception handleResponseError(Document doc, Exception e) throws Exception {
        if (!(e instanceof ResponseException)) {
            if (doc == null) {
                Logger.infoln("Failed parsing XML response from Nerrvana");
            } else {
                Logger.infoln("XML response unserialization failed");
                Logger.infoln(Utils.xml2string(doc));
            }
        }
        return e;
    }

    private String makeUrl(String server, String resource) {
        if (resource == null) {
            return server;
        }
        while (server.endsWith("/")) {
            server = server.substring(0, server.length() - 2);
        }
        while (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        return server + "/" + resource;
    }

    public NerrvanaExecution getExecutionStatus(String exec_id) throws Exception {
        Document doc = null;
        HttpEntity entity = null;
        try {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("id", exec_id));
            entity = this.get("testrun/execution", params);
            doc = Utils.parseResponse(entity);
            ArrayList<NerrvanaExecution> list = NerrvanaExecution.xml2list(doc);
            return (NerrvanaExecution)list.get(0);
        }
        catch (Exception e) {
            throw this.handleResponseError(doc, e);
        }
    }

    public Testrun createTestrun(String space_id, String name, String descr, List<Platform> platforms, String executable_file, boolean bValidation, int nodes_count) throws Exception {
        Document doc = null;
        HttpEntity entity = null;
        StringBuilder sb = new StringBuilder();
        Iterator<Platform> it = platforms.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(it.next().code);
        }
        try {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("space_id", space_id));
            params.add((NameValuePair)new BasicNameValuePair("name", name));
            params.add((NameValuePair)new BasicNameValuePair("description", descr));
            params.add((NameValuePair)new BasicNameValuePair("platforms", sb.toString()));
            params.add((NameValuePair)new BasicNameValuePair("executable_file", executable_file));
            params.add((NameValuePair)new BasicNameValuePair("validation", bValidation ? "1" : "0"));
            params.add((NameValuePair)new BasicNameValuePair("nodes_count", "" + nodes_count));
            entity = this.post("testrun", params);
            doc = Utils.parseResponse(entity);
            return Testrun.getTestrun(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw this.handleResponseError(doc, e);
        }
    }
}

