/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.neoload.integration.steps.NeoloadRunStep;
import org.jenkinsci.plugins.neoload.integration.supporting.GraphOptionsCurveInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.GraphOptionsInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NTSServerInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoloadGraphDefinitionStep;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoloadParseException;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.jenkinsci.plugins.neoload.integration.supporting.ServerInfo;

public class PipelineAsCodeEncodeDecode {
    private static final String EXECUTABLE = "executable";
    private static final String PROJECT = "project";
    private static final String REPORT_XML = "reportXml";
    private static final String REPORT_HTML = "reportHtml";
    private static final String REPORT_JUNIT = "reportJunit";
    private static final String REPORT_PDF = "reportPdf";
    private static final String DISPLAY_GUI = "displayGui";
    private static final String TEST_NAME = "testName";
    private static final String TEST_DESCRIPTION = "testDescription";
    private static final String GRAPH_TRENDS_MAX_POINTS = "graphTrendsMaxPoints";
    private static final String SCENARIO = "scenario";
    private static final String NTS_SERVER = "server";
    private static final String DURATION = "duration";
    private static final String VU_COUNT = "vuCount";
    private static final String VU_SAP_COUNT = "sapVuCount";
    private static final String SHARED_LICENSE = "sharedLicense";
    private static final String COLLAB_SERVER = "server";
    private static final String COLLAB_PROJECT_NAME = "name";
    private static final String PUBLISH_TEST_RESULT = "publishTestResult";
    private static final String GRAPH_AVG_RESPONSE_TIME = "AvgResponseTime";
    private static final String GRAPH_ERROR_RATE = "ErrorRate";
    private static final String TREND_GRAPHS = "trendGraphs";
    private static final String GRAPH_CURVE = "curve";
    private static final String GRAPH_STATISTIC = "statistic";
    private static final String GRAPH_NAME = "name";
    private static final String COMMAND_LINE_OPTION = "commandLineOption";
    private static final String AUTO_ARCHIVE = "autoArchive";

    public static NeoloadRunStep decode(Map<String, Object> map) throws Exception {
        NeoloadRunStep neoloadRunStep = new NeoloadRunStep(PipelineAsCodeEncodeDecode.getString(map, SCENARIO));
        PipelineAsCodeEncodeDecode.parseProject(map, neoloadRunStep);
        PipelineAsCodeEncodeDecode.parseReport(map, neoloadRunStep);
        neoloadRunStep.setExecutable(PipelineAsCodeEncodeDecode.getOptionalString(map, EXECUTABLE, ""));
        neoloadRunStep.setDisplayGUI(PipelineAsCodeEncodeDecode.getOptionalBoolean(map, DISPLAY_GUI, false));
        neoloadRunStep.setTestDescription(PipelineAsCodeEncodeDecode.getOptionalString(map, TEST_DESCRIPTION, ""));
        neoloadRunStep.setTestResultName(PipelineAsCodeEncodeDecode.getOptionalString(map, TEST_NAME, "$Date{hh:mm - dd MMM yyyy} (build ${BUILD_NUMBER})"));
        neoloadRunStep.setCustomCommandLineOptions(PipelineAsCodeEncodeDecode.getOptionalString(map, COMMAND_LINE_OPTION, ""));
        PipelineAsCodeEncodeDecode.parseSharedLicense(map, neoloadRunStep);
        PipelineAsCodeEncodeDecode.decodeGraph(map, neoloadRunStep);
        neoloadRunStep.setAutoArchive(PipelineAsCodeEncodeDecode.getOptionalBoolean(map, AUTO_ARCHIVE, neoloadRunStep.isAutoArchive()));
        return neoloadRunStep;
    }

    public static void encodeGraph(Map<String, Object> map, NeoloadGraphDefinitionStep neoloadGraphDefinitionStep) {
        if (neoloadGraphDefinitionStep.getMaxTrends() > 0) {
            map.put(GRAPH_TRENDS_MAX_POINTS, neoloadGraphDefinitionStep.getMaxTrends());
        }
        PipelineAsCodeEncodeDecode.serializeTrendsGraphs(map, neoloadGraphDefinitionStep);
    }

    public static Map<String, Object> encode(NeoloadRunStep neoloadRunStep) {
        LinkedHashMap<String, Object> stringObjectMap = new LinkedHashMap<String, Object>();
        PipelineAsCodeEncodeDecode.addIfNotEmpty(stringObjectMap, EXECUTABLE, neoloadRunStep.getExecutable());
        stringObjectMap.put(PROJECT, PipelineAsCodeEncodeDecode.serializeProject(neoloadRunStep));
        if ("reportTypeCustom".equals(neoloadRunStep.getReportType())) {
            if (!"neoload-report/report.xml".equals(neoloadRunStep.getXmlReport())) {
                stringObjectMap.put(REPORT_XML, neoloadRunStep.getXmlReport());
            }
            if (!"neoload-report/report.html".equals(neoloadRunStep.getHtmlReport())) {
                stringObjectMap.put(REPORT_HTML, neoloadRunStep.getHtmlReport());
            }
            if (!"neoload-report/junit-sla-results.xml".equals(neoloadRunStep.getJunitReport())) {
                stringObjectMap.put(REPORT_JUNIT, neoloadRunStep.getJunitReport());
            }
            PipelineAsCodeEncodeDecode.addIfNotEmpty(stringObjectMap, REPORT_PDF, neoloadRunStep.getPdfReport());
        }
        if (neoloadRunStep.isDisplayGUI()) {
            stringObjectMap.put(DISPLAY_GUI, "true");
        }
        if (!"$Date{hh:mm - dd MMM yyyy} (build ${BUILD_NUMBER})".equals(neoloadRunStep.getTestResultName())) {
            stringObjectMap.put(TEST_NAME, neoloadRunStep.getTestResultName());
        }
        PipelineAsCodeEncodeDecode.addIfNotEmpty(stringObjectMap, TEST_DESCRIPTION, neoloadRunStep.getTestDescription());
        PipelineAsCodeEncodeDecode.addIfNotEmpty(stringObjectMap, COMMAND_LINE_OPTION, neoloadRunStep.getCustomCommandLineOptions());
        stringObjectMap.put(SCENARIO, neoloadRunStep.getScenarioName());
        PipelineAsCodeEncodeDecode.serializeSharedLicense(stringObjectMap, neoloadRunStep);
        PipelineAsCodeEncodeDecode.encodeGraph(stringObjectMap, neoloadRunStep);
        if (!neoloadRunStep.isAutoArchive()) {
            stringObjectMap.put(AUTO_ARCHIVE, "false");
        }
        return stringObjectMap;
    }

    public static void decodeGraph(Map<String, Object> map, NeoloadGraphDefinitionStep neoloadGraphDefinitionStep) throws NeoloadParseException {
        PipelineAsCodeEncodeDecode.parseTrendGraphs(map, neoloadGraphDefinitionStep);
        neoloadGraphDefinitionStep.setMaxTrends(PipelineAsCodeEncodeDecode.getOptionalNumber(map, GRAPH_TRENDS_MAX_POINTS, 0));
    }

    private static String getOptionalString(Map<String, Object> map, String key, String defaultValue) {
        Object o = map.get(key);
        if (o == null) {
            return defaultValue;
        }
        return o.toString();
    }

    private static boolean getOptionalBoolean(Map<String, Object> map, String key, boolean defaultValue) {
        Object o = map.get(key);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.parseBoolean(o.toString());
        }
        return defaultValue;
    }

    private static int getOptionalNumber(Map<String, Object> map, String key, int defaultValue) {
        Object o = map.get(key);
        if (o != null) {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            return Integer.parseInt(o.toString());
        }
        return defaultValue;
    }

    private static void parseReport(Map<String, Object> map, NeoloadRunStep neoloadRunStep) {
        String reportXML = PipelineAsCodeEncodeDecode.getOptionalString(map, REPORT_XML, null);
        String reportPDF = PipelineAsCodeEncodeDecode.getOptionalString(map, REPORT_PDF, null);
        String reportHTML = PipelineAsCodeEncodeDecode.getOptionalString(map, REPORT_HTML, null);
        String reportJunit = PipelineAsCodeEncodeDecode.getOptionalString(map, REPORT_JUNIT, null);
        boolean isCustom = reportHTML != null || reportJunit != null || reportPDF != null || reportXML != null;
        neoloadRunStep.setReportType(isCustom ? "reportTypeCustom" : "reportTypeDefault");
        if (reportXML != null) {
            neoloadRunStep.setXmlReport(reportXML);
        }
        if (reportHTML != null) {
            neoloadRunStep.setHtmlReport(reportHTML);
        }
        if (reportJunit != null) {
            neoloadRunStep.setJunitReport(reportJunit);
        }
        if (reportPDF != null) {
            neoloadRunStep.setPdfReport(reportPDF);
        }
    }

    private static void parseTrendGraphs(Map<String, Object> map, NeoloadGraphDefinitionStep neoloadRunStep) throws NeoloadParseException {
        Object o = map.get(TREND_GRAPHS);
        if (o instanceof List) {
            ArrayList<GraphOptionsInfo> listOfGraph = new ArrayList<GraphOptionsInfo>();
            for (Object obj : (List)o) {
                if (obj.equals(GRAPH_AVG_RESPONSE_TIME)) {
                    neoloadRunStep.setShowTrendAverageResponse(true);
                    continue;
                }
                if (obj.equals(GRAPH_ERROR_RATE)) {
                    neoloadRunStep.setShowTrendErrorRate(true);
                    continue;
                }
                if (obj instanceof Map) {
                    listOfGraph.add(PipelineAsCodeEncodeDecode.parseGraph((Map)obj));
                    continue;
                }
                throw new NeoloadParseException("Unrecognized graph trends");
            }
            if (!listOfGraph.isEmpty()) {
                neoloadRunStep.setGraphOptionsInfo(listOfGraph);
            }
        }
    }

    private static GraphOptionsInfo parseGraph(Map<String, Object> obj) throws NeoloadParseException {
        GraphOptionsInfo graphOptionsInfo = new GraphOptionsInfo();
        graphOptionsInfo.setStatistic(PipelineAsCodeEncodeDecode.getString(obj, GRAPH_STATISTIC));
        graphOptionsInfo.setName(PipelineAsCodeEncodeDecode.getString(obj, "name"));
        Object curveObj = obj.get(GRAPH_CURVE);
        ArrayList<GraphOptionsCurveInfo> graphOptionsCurveInfos = new ArrayList<GraphOptionsCurveInfo>();
        if (curveObj instanceof List) {
            for (Object curve : (List)curveObj) {
                graphOptionsCurveInfos.add(new GraphOptionsCurveInfo(curve.toString()));
            }
        } else {
            throw new NeoloadParseException("Unrecognized graph");
        }
        graphOptionsInfo.setCurve(graphOptionsCurveInfos);
        return graphOptionsInfo;
    }

    private static void parseSharedLicense(Map<String, Object> map, NeoloadRunStep neoloadRunStep) throws NeoloadParseException {
        Object o = map.get(SHARED_LICENSE);
        if (o != null) {
            if (o instanceof Map) {
                Map sharedLicenseMap = (Map)o;
                neoloadRunStep.setLicenseType("licenseTypeShared");
                neoloadRunStep.setLicenseDuration(PipelineAsCodeEncodeDecode.getString(sharedLicenseMap, DURATION));
                neoloadRunStep.setLicenseServer((NTSServerInfo)PipelineAsCodeEncodeDecode.getServerInfo(PipelineAsCodeEncodeDecode.getString(sharedLicenseMap, "server"), false));
                neoloadRunStep.setLicenseVUCount(PipelineAsCodeEncodeDecode.getString(sharedLicenseMap, VU_COUNT));
                neoloadRunStep.setLicenseVUSAPCount(PipelineAsCodeEncodeDecode.getOptionalString(sharedLicenseMap, VU_SAP_COUNT, ""));
            } else {
                throw new NeoloadParseException("Error during the shared license parsing");
            }
        }
    }

    private static void parseProject(Map<String, Object> map, NeoloadRunStep neoloadRunStep) throws NeoloadParseException {
        Object project = map.get(PROJECT);
        if (project instanceof String) {
            neoloadRunStep.setProjectType("projectTypeLocal");
            neoloadRunStep.setLocalProjectFile((String)project);
        } else if (project instanceof Map) {
            Map projectMap = (Map)project;
            neoloadRunStep.setProjectType("projectTypeShared");
            neoloadRunStep.setSharedProjectName(PipelineAsCodeEncodeDecode.getString(projectMap, "name"));
            neoloadRunStep.setSharedProjectServer(PipelineAsCodeEncodeDecode.getServerInfo(PipelineAsCodeEncodeDecode.getString(projectMap, "server"), true));
        }
    }

    private static ServerInfo getServerInfo(String serverLabel, boolean isCollab) throws NeoloadParseException {
        List<ServerInfo> serverInfos = PluginUtils.getServerInfos(isCollab);
        for (ServerInfo serverInfo : serverInfos) {
            if (!serverLabel.equalsIgnoreCase(serverInfo.getNonEmptyLabel(isCollab))) continue;
            return serverInfo;
        }
        ServerInfo serverInfo = PipelineAsCodeEncodeDecode.computeNearestServerInfo(serverInfos, serverLabel, isCollab);
        if (serverInfo == null) {
            throw new NeoloadParseException("Server " + serverLabel + " not found !");
        }
        return serverInfo;
    }

    private static int computeScore(String s1, String s2) {
        int score = 0;
        if (StringUtils.isNotEmpty((String)s2) && s1.contains(s2)) {
            score = 2;
            if (s1.length() == s2.length()) {
                ++score;
            }
        }
        return score;
    }

    private static ServerInfo computeNearestServerInfo(List<ServerInfo> serverInfos, String serverLabel, boolean isCollab) {
        ServerInfo result = null;
        int maxScore = 0;
        for (ServerInfo serverInfo : serverInfos) {
            int score = PipelineAsCodeEncodeDecode.computeScore(serverLabel, serverInfo.getUrl());
            score += PipelineAsCodeEncodeDecode.computeScore(serverLabel, serverInfo.getLoginUser());
            if (serverInfo instanceof NTSServerInfo) {
                NTSServerInfo ntsInfo = (NTSServerInfo)serverInfo;
                score += PipelineAsCodeEncodeDecode.computeScore(serverLabel, isCollab ? ntsInfo.getCollabPath() : ntsInfo.getLicenseID());
            }
            if (maxScore >= score) continue;
            result = serverInfo;
            maxScore = score;
        }
        return result;
    }

    private static String getString(Map<String, Object> map, String key) throws NeoloadParseException {
        Object object = map.get(key);
        if (object == null) {
            throw new NeoloadParseException(key + " is mandatory");
        }
        return object.toString();
    }

    private static void addIfNotEmpty(Map<String, Object> map, String key, String value) {
        if (value != null && !value.trim().isEmpty()) {
            map.put(key, value);
        }
    }

    private static void serializeSharedLicense(Map<String, Object> stringObjectMap, NeoloadRunStep neoloadRunStep) {
        if ("licenseTypeShared".equals(neoloadRunStep.getLicenseType())) {
            LinkedHashMap<String, Object> confNTS = new LinkedHashMap<String, Object>();
            confNTS.put("server", neoloadRunStep.getLicenseServer().getNonEmptyLabel(false));
            PipelineAsCodeEncodeDecode.storeInteger(confNTS, DURATION, neoloadRunStep.getLicenseDuration());
            PipelineAsCodeEncodeDecode.storeInteger(confNTS, VU_COUNT, neoloadRunStep.getLicenseVUCount());
            if (PluginUtils.isSAP(neoloadRunStep.getLicenseVUSAPCount())) {
                PipelineAsCodeEncodeDecode.storeInteger(confNTS, VU_SAP_COUNT, neoloadRunStep.getLicenseVUSAPCount());
            }
            stringObjectMap.put(SHARED_LICENSE, confNTS);
        }
    }

    private static void storeInteger(Map<String, Object> conf, String key, String value) {
        try {
            conf.put(key, Integer.parseInt(value));
        }
        catch (Exception xe) {
            conf.put(key, value);
        }
    }

    private static Object serializeProject(NeoloadRunStep neoloadRunStep) {
        if ("projectTypeLocal".equals(neoloadRunStep.getProjectType())) {
            return neoloadRunStep.getLocalProjectFile();
        }
        LinkedHashMap<String, Object> confShared = new LinkedHashMap<String, Object>();
        confShared.put("server", neoloadRunStep.getSharedProjectServer().getNonEmptyLabel(true));
        confShared.put("name", neoloadRunStep.getSharedProjectName());
        confShared.put(PUBLISH_TEST_RESULT, neoloadRunStep.isPublishTestResults());
        return confShared;
    }

    private static void serializeTrendsGraphs(Map<String, Object> stringObjectMap, NeoloadGraphDefinitionStep neoloadRunStep) {
        List<Object> graphList = PipelineAsCodeEncodeDecode.serializeCurve(neoloadRunStep.getGraphOptionsInfo());
        if (neoloadRunStep.isShowTrendAverageResponse()) {
            graphList.add(GRAPH_AVG_RESPONSE_TIME);
        }
        if (neoloadRunStep.isShowTrendErrorRate()) {
            graphList.add(GRAPH_ERROR_RATE);
        }
        if (!graphList.isEmpty()) {
            stringObjectMap.put(TREND_GRAPHS, graphList);
        }
    }

    private static List<Object> serializeCurve(List<GraphOptionsInfo> graphsOptionsCurveInfo) {
        ArrayList<Object> graphList = new ArrayList<Object>();
        if (graphsOptionsCurveInfo != null) {
            for (GraphOptionsInfo graphOptionsInfo : graphsOptionsCurveInfo) {
                LinkedHashMap<String, Object> graph = new LinkedHashMap<String, Object>();
                graph.put("name", graphOptionsInfo.getName());
                graph.put(GRAPH_CURVE, PipelineAsCodeEncodeDecode.serializeCurves(graphOptionsInfo.getCurve()));
                graph.put(GRAPH_STATISTIC, graphOptionsInfo.getStatistic());
                graphList.add(graph);
            }
        }
        return graphList;
    }

    private static List<String> serializeCurves(List<GraphOptionsCurveInfo> curves) {
        ArrayList<String> curveList = new ArrayList<String>();
        for (GraphOptionsCurveInfo graphOptionsInfo : curves) {
            curveList.add(graphOptionsInfo.getPath());
        }
        return curveList;
    }
}

