/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.neoload.integration.supporting.GraphOptionsCurveInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.GraphOptionsInfo;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoLoadPluginOptions;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoLoadReportDoc;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoloadCurvesXPathStat;
import org.jenkinsci.plugins.neoload.integration.supporting.NeoloadGraphXPathStat;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.jenkinsci.plugins.neoload.integration.supporting.XMLUtilities;
import org.w3c.dom.Document;

public class NeoloadGraphsStatistics {
    private static final Logger LOGGER = Logger.getLogger(NeoloadGraphsStatistics.class.getName());
    private static final List<Color> availableColors = Arrays.asList(Color.BLUE, Color.GREEN, Color.RED, Color.MAGENTA, Color.CYAN, Color.PINK, Color.ORANGE, Color.gray, Color.YELLOW, Color.darkGray, Color.lightGray);
    private List<NeoloadGraphXPathStat> neoloadGraphXPathStats = new ArrayList<NeoloadGraphXPathStat>();

    public NeoloadGraphsStatistics(NeoLoadPluginOptions neoLoadPluginOptions) {
        List<GraphOptionsInfo> graphOptionsInfos;
        NeoloadCurvesXPathStat stat;
        if (neoLoadPluginOptions.isShowTrendAverageResponse()) {
            stat = new NeoloadCurvesXPathStat("Time", new Color(237, 184, 0), "/report/summary/all-summary/statistic-item[@type='httppage']/@avg");
            this.neoloadGraphXPathStats.add(new NeoloadGraphXPathStat("Avg. Resp. Time (pages)", "Avg Resp Time (secs)", stat));
        }
        if (neoLoadPluginOptions.isShowTrendErrorRate()) {
            stat = new NeoloadCurvesXPathStat("Time", new Color(200, 0, 0), "/report/summary/statistics/statistic[@name='error_percentile']/@value");
            this.neoloadGraphXPathStats.add(new NeoloadGraphXPathStat("Error Rate", "Error Rate %", stat));
        }
        if ((graphOptionsInfos = neoLoadPluginOptions.getGraphOptionsInfo()) != null) {
            for (GraphOptionsInfo graphOptionsInfo : graphOptionsInfos) {
                this.neoloadGraphXPathStats.add(NeoloadGraphsStatistics.convertInfo(graphOptionsInfo));
            }
        }
    }

    private static Color colorFromIndex(int index) {
        return availableColors.get(index % availableColors.size());
    }

    private static NeoloadGraphXPathStat convertInfo(GraphOptionsInfo graphOptionsInfo) {
        return new NeoloadGraphXPathStat(graphOptionsInfo.getName(), graphOptionsInfo.getStatistic(), NeoloadGraphsStatistics.listCurves(graphOptionsInfo));
    }

    private static List<NeoloadCurvesXPathStat> listCurves(GraphOptionsInfo graphOptionsInfo) {
        ArrayList<NeoloadCurvesXPathStat> curves = new ArrayList<NeoloadCurvesXPathStat>();
        int curveCount = 0;
        for (GraphOptionsCurveInfo curveInfo : graphOptionsInfo.getCurve()) {
            curves.add(new NeoloadCurvesXPathStat(curveInfo.getPath(), NeoloadGraphsStatistics.colorFromIndex(curveCount++), NeoLoadReportDoc.getXPathForCustomGraph(curveInfo.getPath(), graphOptionsInfo.getStatistic()), NeoLoadReportDoc.getXPathForCustomMonitorOrLGGraph(curveInfo.getPath(), graphOptionsInfo.getStatistic())));
        }
        return curves;
    }

    public void addReport(File xmlFilePath, int buildNumber) {
        if (xmlFilePath != null) {
            try {
                Document document = XMLUtilities.readXmlFile(xmlFilePath.getAbsolutePath());
                for (NeoloadGraphXPathStat neoloadGraphXPathStat : this.neoloadGraphXPathStats) {
                    neoloadGraphXPathStat.addBuild(buildNumber, document);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception during open file " + xmlFilePath.getAbsolutePath(), e);
            }
        }
    }

    public void addBuild(AbstractBuild<?, ?> build) {
        this.addReport(this.getReportArtifactXML(build), build.getNumber());
    }

    public void addBuild(Run<?, ?> build) {
        this.addReport(this.getReportArtifactXML(build), build.getNumber());
    }

    private File getReportArtifactXML(AbstractBuild<?, ?> build) {
        Run.Artifact artifact = PluginUtils.findArtifact(PluginUtils.getXMLReportPaths(build), build);
        return artifact == null ? null : artifact.getFile();
    }

    private File getReportArtifactXML(Run<?, ?> build) {
        Run.Artifact artifact = PluginUtils.findArtifact(PluginUtils.getXMLReportPaths(build), build);
        return artifact == null ? null : artifact.getFile();
    }

    public void writePng(File path) throws IOException {
        int i = 0;
        for (NeoloadGraphXPathStat neoloadGraphXPathStat : this.neoloadGraphXPathStats) {
            neoloadGraphXPathStat.writePng(new File(path, "stat" + String.format("%02d", i++) + ".png"));
        }
    }

    List<NeoloadGraphXPathStat> getNeoloadGraphXPathStats() {
        return this.neoloadGraphXPathStats;
    }
}

