/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.jenkinsci.plugins.neoload.integration.ProjectSpecificAction;
import org.jenkinsci.plugins.neoload.integration.supporting.PluginUtils;
import org.w3c.dom.Document;

public class NeoloadCurvesXPathStat {
    private static final Logger LOGGER = Logger.getLogger(ProjectSpecificAction.class.getName());
    private final String legend;
    private final List<String> xPaths;
    private final Color color;
    private final Map<Integer, Float> buildToValue = new TreeMap<Integer, Float>();

    public NeoloadCurvesXPathStat(String legend, Color color, String ... xPaths) {
        this.legend = legend;
        this.xPaths = Arrays.asList(xPaths);
        this.color = color;
    }

    public void addBuild(int buildNumber, Document document) {
        for (String xPath : this.xPaths) {
            try {
                Float data = PluginUtils.getCustom(xPath, document);
                if (data == null) continue;
                this.buildToValue.put(buildNumber, data);
                break;
            }
            catch (XPathExpressionException e) {
                LOGGER.log(Level.WARNING, "Exception occurs while parsing results", e);
            }
        }
    }

    public String getLegend() {
        return this.legend;
    }

    public List<String> getxPaths() {
        return this.xPaths;
    }

    public Color getColor() {
        return this.color;
    }

    public Map<Integer, Float> getBuildToValue() {
        return this.buildToValue;
    }

    public int getBuildsNumber() {
        return this.buildToValue.size();
    }
}

