/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.neoload.integration.supporting;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jenkinsci.plugins.neoload.integration.supporting.ServerInfo;
import org.kohsuke.stapler.DataBoundConstructor;

public class NTSServerInfo
extends ServerInfo
implements Serializable,
Comparable<NTSServerInfo>,
Comparator<NTSServerInfo> {
    private static final long serialVersionUID = 3912702075580266980L;
    private String collabPath;
    private String licenseID;

    public NTSServerInfo() {
    }

    @DataBoundConstructor
    public NTSServerInfo(String uniqueID, String url, String loginUser, String loginPassword, String label, String collabPath, String licenseID) {
        super(uniqueID, url, loginUser, loginPassword, label);
        this.collabPath = collabPath;
        this.licenseID = licenseID;
    }

    public String getCollabPath() {
        return this.collabPath;
    }

    public void setCollabPath(String collabPath) {
        this.collabPath = collabPath;
    }

    @Override
    public String getNonEmptyLabel(boolean forCollab) {
        if (this.getLabel().trim().isEmpty()) {
            String info = forCollab ? ", Repository: " + this.getCollabPath() : ", LicenseId: " + this.getLicenseID();
            return this.getUrl() + ", User: " + this.getLoginUser() + info;
        }
        return this.getLabel();
    }

    public String getLicenseID() {
        return this.licenseID;
    }

    public void setLicenseID(String licenseID) {
        this.licenseID = licenseID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public int compare(NTSServerInfo o1, NTSServerInfo o2) {
        return CompareToBuilder.reflectionCompare((Object)o1, (Object)o2);
    }

    @Override
    public int compareTo(NTSServerInfo o) {
        return this.compare(this, o);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

