/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.multiplescms;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MultiSCMChangeLogSet
extends ChangeLogSet<ChangeLogSet.Entry> {
    private final HashMap<String, ChangeLogSetWrapper> changes = new HashMap();
    private final Set<String> kinds = new HashSet<String>();

    protected MultiSCMChangeLogSet(AbstractBuild<?, ?> build) {
        super(build);
    }

    public Iterator<ChangeLogSet.Entry> iterator() {
        return new MultiSCMChangeLogSetIterator(this);
    }

    public boolean isEmptySet() {
        return this.changes.isEmpty();
    }

    public void add(String scmClass, String scmFriendlyName, ChangeLogSet<? extends ChangeLogSet.Entry> cls) {
        if (!cls.isEmptySet()) {
            ChangeLogSetWrapper wrapper = this.changes.get(scmClass);
            if (wrapper == null) {
                wrapper = new ChangeLogSetWrapper(this.build, cls.getBrowser(), scmFriendlyName, cls.getClass());
                this.changes.put(scmClass, wrapper);
            }
            wrapper.addChanges(cls);
        }
        this.kinds.add(cls.getKind());
    }

    public Collection<ChangeLogSetWrapper> getChangeLogSetWrappers() {
        return this.changes.values();
    }

    public String getKind() {
        if (this.kinds.size() == 1) {
            return this.kinds.iterator().next();
        }
        return "Multi" + this.kinds;
    }

    private static class MultiSCMChangeLogSetIterator
    implements Iterator<ChangeLogSet.Entry> {
        MultiSCMChangeLogSet set;
        Iterator<String> scmIter = null;
        String currentScm = null;
        Iterator<ChangeLogSet.Entry> logIter = null;

        public MultiSCMChangeLogSetIterator(MultiSCMChangeLogSet set) {
            this.set = set;
            this.scmIter = set.changes.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.logIter == null || !this.logIter.hasNext()) {
                return this.scmIter.hasNext();
            }
            return true;
        }

        @Override
        public ChangeLogSet.Entry next() {
            if (this.logIter == null || !this.logIter.hasNext()) {
                this.currentScm = this.scmIter.next();
                this.logIter = ((ChangeLogSetWrapper)((Object)this.set.changes.get(this.currentScm))).logs.iterator();
            }
            return this.logIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove changeset items");
        }
    }

    public static class ChangeLogSetWrapper
    extends ChangeLogSet<ChangeLogSet.Entry> {
        private List<ChangeLogSet.Entry> logs = new ArrayList<ChangeLogSet.Entry>();
        private Class clazz;
        private String friendlyName;

        public ChangeLogSetWrapper(AbstractBuild build, String friendlyName, Class handler) {
            super(build);
            this.clazz = handler;
            this.friendlyName = friendlyName;
        }

        public ChangeLogSetWrapper(AbstractBuild build, RepositoryBrowser<?> browser, String friendlyName, Class handler) {
            super((Run)build, browser);
            this.clazz = handler;
            this.friendlyName = friendlyName;
        }

        public AbstractBuild getBuild() {
            return this.build;
        }

        public Class getHandlerClass() {
            return this.clazz;
        }

        public String getName() {
            return this.friendlyName;
        }

        public List<ChangeLogSet.Entry> getLogs() {
            return this.logs;
        }

        public void addChanges(ChangeLogSet<? extends ChangeLogSet.Entry> cls) {
            for (ChangeLogSet.Entry e : cls) {
                this.logs.add(e);
            }
        }

        public Iterator<ChangeLogSet.Entry> iterator() {
            return this.logs.iterator();
        }

        public boolean isEmptySet() {
            return this.logs.isEmpty();
        }
    }
}

