/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mattermost;

import hudson.ProxyConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.mattermost.MattermostService;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class StandardMattermostService
implements MattermostService {
    private static final Logger logger = Logger.getLogger(StandardMattermostService.class.getName());
    private String endpoint;
    private String[] roomIds;
    private String icon;

    public StandardMattermostService(String endpoint, String roomId, String icon) {
        this.endpoint = endpoint;
        this.roomIds = roomId.split("[,;]+");
        this.icon = icon;
    }

    @Override
    public boolean publish(String message) {
        return this.publish(message, "warning");
    }

    @Override
    public boolean publish(String message, String color) {
        return this.publish(message, "", color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publish(String message, String text, String color) {
        boolean result = true;
        for (String userAndRoomId : this.roomIds) {
            String roomIdString;
            String url = this.endpoint;
            String roomId = userAndRoomId.trim();
            String userId = "jenkins";
            int atPos = userAndRoomId.indexOf("@");
            if (atPos > 0 && atPos < userAndRoomId.length() - 1) {
                userId = userAndRoomId.substring(0, atPos).trim();
                roomId = userAndRoomId.substring(atPos + 1).trim();
            }
            if (StringUtils.isEmpty((String)(roomIdString = roomId))) {
                roomIdString = "(default)";
            }
            logger.info("Posting: to " + roomIdString + "@" + url + ": " + message + " (" + color + ")");
            HttpClient client = this.getHttpClient();
            PostMethod post = new PostMethod(url);
            JSONObject json = new JSONObject();
            try {
                JSONObject field = new JSONObject();
                field.put("short", false);
                field.put("value", (Object)message);
                JSONArray fields = new JSONArray();
                fields.put((Object)field);
                JSONObject attachment = new JSONObject();
                attachment.put("fallback", (Object)message);
                attachment.put("color", (Object)color);
                attachment.put("fields", (Object)fields);
                JSONArray mrkdwn = new JSONArray();
                mrkdwn.put((Object)"pretext");
                mrkdwn.put((Object)"text");
                mrkdwn.put((Object)"fields");
                attachment.put("mrkdwn_in", (Object)mrkdwn);
                JSONArray attachments = new JSONArray();
                attachments.put((Object)attachment);
                json.put("text", (Object)text);
                json.put("attachments", (Object)attachments);
                if (!roomId.isEmpty()) {
                    json.put("channel", (Object)roomId);
                }
                json.put("username", (Object)userId);
                json.put("icon_url", (Object)this.icon);
                post.addParameter("payload", json.toString());
                post.getParams().setContentCharset("UTF-8");
                int responseCode = client.executeMethod((HttpMethod)post);
                String response = post.getResponseBodyAsString();
                if (responseCode == 200) continue;
                logger.log(Level.WARNING, "Mattermost post may have failed. Response: " + response);
                result = false;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error posting to Mattermost", e);
                result = false;
            }
            finally {
                logger.info("Posting succeeded");
                post.releaseConnection();
            }
        }
        return result;
    }

    protected HttpClient getHttpClient() {
        ProxyConfiguration proxy;
        HttpClient client = new HttpClient();
        if (Jenkins.getInstance() != null && (proxy = Jenkins.getInstance().proxy) != null && this.isProxyRequired(proxy.getNoProxyHostPatterns())) {
            client.getHostConfiguration().setProxy(proxy.name, proxy.port);
            String username = proxy.getUserName();
            String password = proxy.getPassword();
            if (username != null && !"".equals(username.trim())) {
                logger.info("Using proxy authentication (user=" + username + ")");
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        return client;
    }

    protected boolean isProxyRequired(List<Pattern> noProxyHosts) {
        try {
            URL url = new URL(this.endpoint);
            for (Pattern p : noProxyHosts) {
                if (!p.matcher(url.getHost()).matches()) continue;
                return false;
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "A malformed URL [" + this.endpoint + "] is defined as endpoint, please check your settings");
            return true;
        }
        return true;
    }

    void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

