/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.Extension;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.Messages;
import hudson.model.labels.LabelAtom;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class LabelAxis
extends Axis {
    @DataBoundConstructor
    public LabelAxis(String name, List<String> values) {
        super(name, values);
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public String getValueString() {
        return String.join((CharSequence)"/", this.getValues());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isChecked(String name) {
        return this.getValues().contains(name);
    }

    @Restricted(value={NoExternalUse.class})
    public static class LabelLists {
        private List<LabelAtom> machines = new ArrayList<LabelAtom>();
        private List<LabelAtom> labels = new ArrayList<LabelAtom>();

        public LabelLists() {
            Set labelsAtoms = Jenkins.get().getLabelAtoms();
            labelsAtoms.forEach(atom -> {
                if (atom.isSelfLabel()) {
                    this.machines.add((LabelAtom)atom);
                } else {
                    this.labels.add((LabelAtom)atom);
                }
            });
        }

        public List<LabelAtom> getMachines() {
            return this.machines;
        }

        public List<LabelAtom> getLabels() {
            return this.labels;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public String getDisplayName() {
            return Messages.LabelAxis_DisplayName();
        }

        @Override
        public boolean isInstantiable() {
            Jenkins j = Jenkins.getActiveInstance();
            return !j.getNodes().isEmpty() || !j.clouds.isEmpty();
        }

        @Restricted(value={NoExternalUse.class})
        public LabelLists getLabelLists() {
            return new LabelLists();
        }

        @Restricted(value={NoExternalUse.class})
        public String getSaveDescription(LabelAtom labelAtom) throws IOException {
            return Jenkins.get().getMarkupFormatter().translate(labelAtom.getDescription()).replaceAll("\r", "").replaceAll("\n", "");
        }
    }
}

