/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.EnvVars;
import hudson.Extension;
import hudson.matrix.MatrixChildAction;
import hudson.matrix.MatrixRun;
import hudson.model.EnvironmentContributor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class MatrixChildParametersAction
extends ParametersAction
implements MatrixChildAction {
    private final List<ParameterValue> parameters;

    MatrixChildParametersAction(List<ParameterValue> parameters) {
        super(new ParameterValue[0]);
        this.parameters = parameters;
    }

    public List<ParameterValue> getParameters() {
        return this.parameters;
    }

    public ParameterValue getParameter(String name) {
        for (ParameterValue p : this.parameters) {
            if (p == null || !p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    static MatrixChildParametersAction create(ParametersAction action) {
        ArrayList<ParameterValue> p = new ArrayList<ParameterValue>();
        if (action != null) {
            p.addAll(action.getParameters());
        }
        return new MatrixChildParametersAction(p);
    }

    @Extension
    public static final class MatrixChildParametersActionEnvironmentContributor
    extends EnvironmentContributor {
        public void buildEnvironmentFor(@Nonnull Run r, @Nonnull EnvVars envs, @Nonnull TaskListener listener) throws IOException, InterruptedException {
            MatrixChildParametersAction childParameters;
            if (r instanceof MatrixRun && (childParameters = (MatrixChildParametersAction)r.getAction(MatrixChildParametersAction.class)) != null) {
                for (ParameterValue p : childParameters.getParameters()) {
                    MatrixChildParametersActionEnvironmentContributor.putEnvVar(envs, p.getName(), String.valueOf(p.getValue()));
                }
            }
        }

        private static void putEnvVar(@Nonnull EnvVars envs, String name, String value) {
            if (value != null) {
                envs.put(name, value);
            } else {
                envs.put(name, "");
            }
        }
    }
}

